/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui.overlay;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.stln.magitech.Magitech;
import net.stln.magitech.event.KeyMappingEvent;
import net.stln.magitech.item.ItemTagKeys;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.ToolBeltComponent;
import net.stln.magitech.network.SwapToolFromBeltPayload;
import net.stln.magitech.util.ClientHelper;
import net.stln.magitech.util.ColorHelper;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.CuriosHelper;
import net.stln.magitech.util.MathUtil;
import net.stln.magitech.util.RenderHelper;
import net.stln.magitech.util.ToolBeltHelper;
import org.jetbrains.annotations.NotNull;

public class ToolBeltOverlay
extends Screen {
    private static final ResourceLocation TEXTURE = Magitech.id("textures/gui/tool_belt.png");
    static int ANIM_LENGTH = 10;
    private int ticks = 0;
    private int select = -1;

    public ToolBeltOverlay() {
        super((Component)Component.empty());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!Minecraft.getInstance().options.hideGui) {
            int x = guiGraphics.guiWidth() / 2;
            int y = guiGraphics.guiHeight() / 2;
            double dx = mouseX - x;
            double dy = mouseY - y;
            double naturalMouseAngle = MathUtil.getGeneralAngle(Math.atan2(dy, dx) + 1.5707963267948966);
            Player player = ClientHelper.getPlayer();
            if (player == null) {
                return;
            }
            ToolBeltComponent toolBeltComponent = CuriosHelper.getToolBeltStack((LivingEntity)player).map(ComponentHelper::getToolsInBelt).orElse(ToolBeltComponent.EMPTY);
            guiGraphics.blit(TEXTURE, x - 51, y - 51, 0, 0, 102, 102);
            for (int i = 0; i < 8; ++i) {
                ItemStack tool;
                float animTick = Math.min((float)this.ticks + partialTicks, (float)ANIM_LENGTH);
                double scaledAnimTick = (double)animTick / (double)ANIM_LENGTH;
                float radius = (int)(51.0 - Math.pow(1.0 - scaledAnimTick, 3.0) * 25.0);
                double mouseAngle = naturalMouseAngle;
                double angle = Math.PI * 2 * (double)i / 8.0;
                float sin = (float)((double)radius * Math.sin(angle));
                float cos = (float)(-((double)radius * Math.cos(angle)));
                double min = MathUtil.getGeneralAngle(Math.PI * 2 * ((double)i - 0.5) / 8.0);
                double max = MathUtil.getGeneralAngle(Math.PI * 2 * ((double)i + 0.5) / 8.0);
                if (i == 0) {
                    min -= Math.PI * 2;
                    if (mouseAngle > max) {
                        mouseAngle -= Math.PI * 2;
                    }
                }
                double distance = Math.sqrt(dx * dx + dy * dy);
                if (mouseAngle >= min && mouseAngle <= max && distance > 10.0) {
                    if (this.select != i) {
                        this.select = i;
                    }
                } else if (distance <= 10.0) {
                    this.select = -1;
                }
                guiGraphics.blit(TEXTURE, (int)((float)x + sin - 11.0f), (int)((float)y + cos - 11.0f), 102, 0, 22, 22);
                if (this.select == i) {
                    guiGraphics.blit(TEXTURE, (int)((float)x + sin - 12.0f), (int)((float)y + cos - 12.0f), 124, 0, 24, 24);
                }
                if ((tool = toolBeltComponent.stacks().get(i)).isEmpty()) continue;
                guiGraphics.renderItem(tool, (int)((float)x + sin - 8.0f), (int)((float)y + cos - 8.0f));
                if (this.select != i) continue;
                MutableComponent toolName = Component.empty().append(tool.getHoverName()).withStyle(tool.getRarity().getStyleModifier()).withStyle(p_220170_ -> p_220170_.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(tool))));
                int color = toolName.getStyle().getColor().getValue();
                RenderHelper.renderFramedText(guiGraphics, Minecraft.getInstance().font, toolName.getString(), x - Minecraft.getInstance().font.width((FormattedText)toolName) / 2, y + 70, color, ColorHelper.Argb.mul(color, 0x404060));
            }
        }
    }

    public void tick() {
        super.tick();
        ++this.ticks;
    }

    public void onClose() {
        super.onClose();
        Player player = ClientHelper.getPlayer();
        if (player == null || !this.canChangeTool(player)) {
            return;
        }
        CuriosHelper.getToolBeltStack((LivingEntity)player).ifPresent(stack -> {
            if (stack.has(ComponentInit.TOOLBELT_COMPONENT) && this.select >= 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SwapToolFromBeltPayload(this.select, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ToolBeltHelper.swapTool(player, stack, this.select);
            }
        });
    }

    private boolean canChangeTool(Player player) {
        if (this.select < 0) {
            return false;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        return stack.isEmpty() || stack.getTags().anyMatch(tag -> tag.equals(ItemTagKeys.TOOLS));
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ((KeyMapping)KeyMappingEvent.TOOL_BELT.get()).getKey().getValue()) {
            this.onClose();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

