/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.stln.magitech.item.TooltipTextItem;
import net.stln.magitech.magic.mana.ManaData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class AggregatedLuminisItem
extends TooltipTextItem {
    public AggregatedLuminisItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        double maxMana;
        ItemStack stack = player.getItemInHand(usedHand);
        double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.LUMINIS);
        if (currentMana < (maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.LUMINIS))) {
            if (!player.isCreative()) {
                stack.setCount(stack.getCount() - 1);
            }
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.CRYSTAL_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 0.9f), new Vector3f(1.0f, 0.8f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 20);
            ManaUtil.setMana(player, ManaUtil.ManaType.LUMINIS, Math.min(currentMana + 15.0, maxMana));
            player.hurt(player.damageSources().magic(), 5.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.hint.item.magitech.aggregated_luminis").withColor(0xFFF0C0));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

