/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item;

import java.util.List;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.stln.magitech.item.TooltipTextItem;
import net.stln.magitech.util.ClientHelper;
import net.stln.magitech.util.ColorHelper;
import net.stln.magitech.util.ComponentHelper;
import org.jetbrains.annotations.NotNull;

public class ThreadPageItem
extends TooltipTextItem {
    public ThreadPageItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return (Component)ComponentHelper.getThreadPageSpell((DataComponentHolder)stack).map(spell -> Component.translatable((String)"item.magitech.thread_page", (Object[])new Object[]{spell.getDescription()})).orElseGet(() -> super.getName(stack).copy());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        ComponentHelper.getThreadPageSpell((DataComponentHolder)stack).ifPresent(spell -> {
            tooltipComponents.add((Component)spell.getDescription().withColor(spell.getElement().getSpellColor()));
            Player player = ClientHelper.getPlayer();
            if (player == null) {
                return;
            }
            List<Component> componentList = spell.getTooltip(player.level(), player, stack);
            int i = 0;
            for (Component component : componentList) {
                int col = component.getStyle().getColor() != null ? component.getStyle().getColor().getValue() : 0x808080;
                int newCol = ColorHelper.Argb.getArgb(ColorHelper.Argb.getRed(col) / 2, ColorHelper.Argb.getGreen(col) / 2, ColorHelper.Argb.getBlue(col) / 2);
                componentList.set(i, (Component)Component.empty().append((Component)((MutableComponent)component).withColor(newCol)));
                ++i;
            }
            tooltipComponents.addAll(componentList);
        });
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

