/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.armor;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.item.armor.AetherLifterRenderer;
import net.stln.magitech.item.armor.TooltipArmorItem;
import net.stln.magitech.particle.particle_option.SquareFieldParticleEffect;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AetherLifterItem
extends TooltipArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AetherLifterItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public static void doubleJump(Player player, int jumpCount, ItemStack stack) {
        if (jumpCount == 0) {
            Level level = player.level();
            Vec3 movement = player.getDeltaMovement();
            player.setDeltaMovement(new Vec3(movement.x, 0.8, movement.z));
            player.fallDistance = -5.0f;
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.AETHER_LIFTER_JUMP.get(), SoundSource.PLAYERS, 1.0f, Mth.nextFloat((RandomSource)player.getRandom(), (float)0.8f, (float)1.2f));
            if (level.isClientSide) {
                int i;
                ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(Magitech.id("animation"));
                if (playerAnimationData != null) {
                    player.yBodyRot = player.yHeadRot;
                    playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)4, (Ease)Ease.INOUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("double_jump"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(false, false, true, true)));
                }
                Vector3f phantomCol = new Vector3f(1.0f, 1.0f, 0.5f);
                Vector3f hollowCol = new Vector3f(0.3f, 0.0f, 1.0f);
                Vec3 position = player.position();
                Vec3 surface = EntityUtil.findSurface(level, position);
                for (i = 0; i < 10; ++i) {
                    double x = player.getX() + Mth.nextDouble((RandomSource)player.getRandom(), (double)(-player.getBbWidth()), (double)player.getBbWidth());
                    double y = player.getY() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.25, (double)0.25);
                    double z = player.getZ() + Mth.nextDouble((RandomSource)player.getRandom(), (double)(-player.getBbWidth()), (double)player.getBbWidth());
                    if (player.getRandom().nextBoolean()) {
                        level.addParticle((ParticleOptions)new SquareParticleEffect(hollowCol, phantomCol, 1.0f, player.getRandom().nextInt(3, 6), 0.0f), x, y, z, 0.0, 0.05, 0.0);
                        continue;
                    }
                    level.addParticle((ParticleOptions)new SquareParticleEffect(phantomCol, hollowCol, 1.0f, player.getRandom().nextInt(3, 6), 0.0f), x, y, z, 0.0, 0.05, 0.0);
                }
                i = 0;
                while ((double)i < position.distanceTo(surface) * 5.0) {
                    Vec3 lerped = surface.lerp(position, (double)i / position.distanceTo(surface) / 5.0);
                    double x = lerped.x + Mth.nextDouble((RandomSource)player.getRandom(), (double)(-player.getBbWidth()), (double)player.getBbWidth()) / 2.0;
                    double y = lerped.y + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.25, (double)0.25);
                    double z = lerped.z + Mth.nextDouble((RandomSource)player.getRandom(), (double)(-player.getBbWidth()), (double)player.getBbWidth()) / 2.0;
                    if (player.getRandom().nextBoolean()) {
                        level.addParticle((ParticleOptions)new SquareParticleEffect(hollowCol, phantomCol, 1.0f, player.getRandom().nextInt(3, 6), 0.0f), x, y, z, 0.0, 0.05, 0.0);
                    } else {
                        level.addParticle((ParticleOptions)new SquareParticleEffect(phantomCol, hollowCol, 1.0f, player.getRandom().nextInt(3, 6), 0.0f), x, y, z, 0.0, 0.05, 0.0);
                    }
                    ++i;
                }
                if (player.getRandom().nextBoolean()) {
                    level.addParticle((ParticleOptions)new SquareFieldParticleEffect(hollowCol, phantomCol, 1.0f, 1, 0.0f), player.getX() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1), player.getY() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1), player.getZ() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1), 0.0, 0.0, 0.0);
                } else {
                    level.addParticle((ParticleOptions)new SquareFieldParticleEffect(phantomCol, hollowCol, 1.0f, 1, 0.0f), player.getX() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1), player.getY() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1), player.getZ() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1), 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 10; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        TickScheduler.schedule(i + 1, () -> {
                            double x = player.getX() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1);
                            double y = player.getY() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1);
                            double z = player.getZ() + Mth.nextDouble((RandomSource)player.getRandom(), (double)-0.1, (double)0.1);
                            if (player.getRandom().nextBoolean()) {
                                level.addParticle((ParticleOptions)new SquareParticleEffect(hollowCol, phantomCol, 1.0f, player.getRandom().nextInt(3, 6), 0.0f), x, y, z, 0.0, 0.05, 0.0);
                            } else {
                                level.addParticle((ParticleOptions)new SquareParticleEffect(phantomCol, hollowCol, 1.0f, player.getRandom().nextInt(3, 6), 0.0f), x, y, z, 0.0, 0.05, 0.0);
                            }
                        }, level.isClientSide);
                    }
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, state -> PlayState.CONTINUE));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GeoArmorRenderer<?> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new AetherLifterRenderer();
                }
                return this.renderer;
            }
        });
    }
}

