/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.fluid;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.stln.magitech.MagitechRegistries;
import net.stln.magitech.item.component.ComponentInit;

public class AlchemicalFlaskFluidHandler
extends FluidHandlerItemStackSimple {
    public AlchemicalFlaskFluidHandler(ItemStack container, int capacity) {
        super(ComponentInit.FLUID_CONTENT_COMPONENT, container, capacity);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int fillAmount;
        if (this.container.getCount() < 1 || resource.isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty() && (fillAmount = Math.min(this.capacity, resource.getAmount())) == this.capacity) {
            if (action.execute()) {
                MagitechRegistries.FLUID_CONTAINER_MATCHER.stream().filter(matcher -> matcher.fillingMatches(this.container, resource)).findFirst().ifPresent(matcher -> {
                    this.container = matcher.filledContainer().asItem().getDefaultInstance();
                });
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    protected void setContainerToEmpty() {
        MagitechRegistries.FLUID_CONTAINER_MATCHER.stream().filter(matcher -> matcher.emptyingMatches(this.container)).findFirst().ifPresent(matcher -> {
            this.container = matcher.emptyContainer().asItem().getDefaultInstance();
        });
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return MagitechRegistries.FLUID_CONTAINER_MATCHER.stream().anyMatch(matcher -> matcher.fillingMatches(this.container, stack));
    }

    public int getTankCapacity(int tank) {
        return super.getTankCapacity(tank);
    }
}

