/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.fluid.potion;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.stln.magitech.entity.mob_effect.MobEffectInit;
import net.stln.magitech.item.fluid.DrinkableFlaskItem;
import net.stln.magitech.magic.mana.ManaData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class ManaPotionFlaskItem
extends DrinkableFlaskItem {
    public ManaPotionFlaskItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected void applyEffects(Level level, LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.MANA);
            double maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.MANA);
            ManaUtil.setMana(player, ManaUtil.ManaType.MANA, Math.min(currentMana + 90.0, maxMana));
        }
        EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.9f, 1.0f, 0.7f), new Vector3f(0.3f, 1.0f, 0.9f), 1.0f, 1, 0.0f), (Entity)entity, 20);
        entity.addEffect(new MobEffectInstance(MobEffectInit.MANA_REGENERATION, 300, 1));
    }
}

