/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.material.MiningLevel;
import oshi.annotation.concurrent.Immutable;

public class ToolStats {
    @Immutable
    public static final ToolStats DEFAULT = new ToolStats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Element.NONE, MiningLevel.NONE, 0);
    public static String ATK_STAT = "attack";
    public static String ELM_ATK_STAT = "element_attack";
    public static String SPD_STAT = "attack_speed";
    public static String MIN_STAT = "mining_speed";
    public static String DEF_STAT = "defense";
    public static String RNG_STAT = "attack_range";
    public static String SWP_STAT = "sweep_range";
    public static String DUR_STAT = "durability";
    public static String PWR_STAT = "attack";
    public static String ELM_PWR_STAT = "element_attack";
    public static String CHG_STAT = "attack_speed";
    public static String CLD_STAT = "mining_speed";
    public static String PRJ_STAT = "attack_range";
    public static String MNA_STAT = "sweep_range";
    private final Map<String, Float> stats = new HashMap<String, Float>();
    private final Element element;
    private final MiningLevel miningLevel;
    private final int tier;

    public ToolStats(float atk, float elmAtk, float spd, float min, float def, float rng, float swp, float dur, Element elm, MiningLevel miningLevel, int tier) {
        this.miningLevel = miningLevel;
        this.tier = tier;
        this.stats.put(ATK_STAT, Float.valueOf(atk));
        this.stats.put(ELM_ATK_STAT, Float.valueOf(elmAtk));
        this.stats.put(SPD_STAT, Float.valueOf(spd));
        this.stats.put(MIN_STAT, Float.valueOf(min));
        this.stats.put(DEF_STAT, Float.valueOf(def));
        this.stats.put(RNG_STAT, Float.valueOf(rng));
        this.stats.put(SWP_STAT, Float.valueOf(swp));
        this.stats.put(DUR_STAT, Float.valueOf(dur));
        this.element = elm;
    }

    public ToolStats(Map<String, Float> map, Element elm, MiningLevel miningLevel, int tier) {
        this.miningLevel = miningLevel;
        this.tier = tier;
        this.stats.putAll(map);
        this.element = elm;
    }

    public static ToolStats add(List<ToolStats> statsList) {
        float atk = 0.0f;
        float elmAtk = 0.0f;
        float spd = 0.0f;
        float min = 0.0f;
        float def = 0.0f;
        float rng = 0.0f;
        float swp = 0.0f;
        float dur = 0.0f;
        HashMap<Element, Float> elementMap = new HashMap<Element, Float>();
        Element elm = Element.NONE;
        MiningLevel minLv = MiningLevel.NONE;
        int tier = 0;
        for (ToolStats stats : statsList) {
            if (stats == null) continue;
            Map<String, Float> map = stats.getStats();
            if (map.get(ATK_STAT) != null) {
                atk += map.get(ATK_STAT).floatValue();
            }
            if (map.get(SPD_STAT) != null) {
                spd += map.get(SPD_STAT).floatValue();
            }
            if (map.get(MIN_STAT) != null) {
                min += map.get(MIN_STAT).floatValue();
            }
            if (map.get(DEF_STAT) != null) {
                def += map.get(DEF_STAT).floatValue();
            }
            if (map.get(RNG_STAT) != null) {
                rng += map.get(RNG_STAT).floatValue();
            }
            if (map.get(SWP_STAT) != null) {
                swp += map.get(SWP_STAT).floatValue();
            }
            if (map.get(DUR_STAT) != null) {
                dur += map.get(DUR_STAT).floatValue();
            }
            Element currentElm = stats.getElement();
            if (map.get(ELM_ATK_STAT) != null) {
                elementMap.put(currentElm, Float.valueOf(elementMap.getOrDefault((Object)currentElm, Float.valueOf(0.0f)).floatValue() + map.get(ELM_ATK_STAT).floatValue()));
            }
            if (stats.getMiningLevel().getTier() > minLv.getTier()) {
                minLv = stats.getMiningLevel();
            }
            tier += stats.getTier();
        }
        ArrayList<Element> elementList = new ArrayList<Element>(List.of(Element.EMBER, Element.GLACE, Element.SURGE, Element.PHANTOM, Element.TREMOR, Element.MAGIC, Element.FLOW, Element.HOLLOW));
        for (Element element1 : elementList) {
            if (elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue() > elmAtk) {
                elm = element1;
                elmAtk = elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue();
                continue;
            }
            if (elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue() != elmAtk) continue;
            elm = Element.NONE;
            elmAtk = 0.0f;
        }
        for (Element element2 : elementList) {
            if (elm == element2) continue;
            elmAtk += (float)((double)elementMap.getOrDefault((Object)element2, Float.valueOf(0.0f)).floatValue() * 0.75);
        }
        elementList.add(Element.NONE);
        for (Element element1 : elementList) {
            if (element1 == elm) continue;
            elmAtk += elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue() * (element1 == Element.NONE ? 1.0f : 0.5f);
        }
        return new ToolStats(atk, elmAtk, spd, min, def, rng, swp, dur, elm, minLv, tier);
    }

    public static ToolStats addWithoutElementCode(List<ToolStats> statsList) {
        float atk = 0.0f;
        float elmAtk = 0.0f;
        float spd = 0.0f;
        float min = 0.0f;
        float def = 0.0f;
        float rng = 0.0f;
        float swp = 0.0f;
        float dur = 0.0f;
        HashMap<Element, Float> elementMap = new HashMap<Element, Float>();
        Element elm = Element.NONE;
        MiningLevel minLv = MiningLevel.NONE;
        int tier = 0;
        for (ToolStats stats : statsList) {
            if (stats == null) continue;
            Map<String, Float> map = stats.getStats();
            if (map.get(ATK_STAT) != null) {
                atk += map.get(ATK_STAT).floatValue();
            }
            if (map.get(SPD_STAT) != null) {
                spd += map.get(SPD_STAT).floatValue();
            }
            if (map.get(MIN_STAT) != null) {
                min += map.get(MIN_STAT).floatValue();
            }
            if (map.get(DEF_STAT) != null) {
                def += map.get(DEF_STAT).floatValue();
            }
            if (map.get(RNG_STAT) != null) {
                rng += map.get(RNG_STAT).floatValue();
            }
            if (map.get(SWP_STAT) != null) {
                swp += map.get(SWP_STAT).floatValue();
            }
            if (map.get(DUR_STAT) != null) {
                dur += map.get(DUR_STAT).floatValue();
            }
            Element currentElm = stats.getElement();
            if (map.get(ELM_ATK_STAT) != null) {
                elementMap.put(currentElm, Float.valueOf(elementMap.getOrDefault((Object)currentElm, Float.valueOf(0.0f)).floatValue() + map.get(ELM_ATK_STAT).floatValue()));
            }
            if (stats.getMiningLevel().getTier() > minLv.getTier()) {
                minLv = stats.getMiningLevel();
            }
            tier += stats.getTier();
        }
        ArrayList<Element> elementList = new ArrayList<Element>(List.of(Element.NONE, Element.EMBER, Element.GLACE, Element.SURGE, Element.PHANTOM, Element.TREMOR, Element.MAGIC, Element.FLOW, Element.HOLLOW));
        for (Element element1 : elementList) {
            if (elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue() > elmAtk) {
                elm = element1;
                elmAtk = elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue();
                continue;
            }
            if (elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue() != elmAtk) continue;
            elm = Element.NONE;
        }
        for (Element element2 : elementList) {
            if (elm == element2) continue;
            elmAtk += (float)((double)elementMap.getOrDefault((Object)element2, Float.valueOf(0.0f)).floatValue() * 0.75);
        }
        for (Element element1 : elementList) {
            if (element1 == elm) continue;
            elmAtk += elementMap.getOrDefault((Object)element1, Float.valueOf(0.0f)).floatValue() * (element1 == Element.NONE ? 1.0f : 0.5f);
        }
        return new ToolStats(atk, elmAtk, spd, min, def, rng, swp, dur, elm, minLv, tier);
    }

    public static ToolStats mulWithoutElementCode(ToolStats stats, float value) {
        float atk = 0.0f;
        float elmAtk = 0.0f;
        float spd = 0.0f;
        float min = 0.0f;
        float def = 0.0f;
        float rng = 0.0f;
        float swp = 0.0f;
        float dur = 0.0f;
        HashMap elementMap = new HashMap();
        Element elm = Element.NONE;
        MiningLevel minLv = MiningLevel.NONE;
        int tier = 0;
        if (stats != null) {
            Map<String, Float> map = stats.getStats();
            if (map.get(ATK_STAT) != null) {
                atk = map.get(ATK_STAT).floatValue() * value;
            }
            if (map.get(ELM_ATK_STAT) != null) {
                elmAtk = map.get(ELM_ATK_STAT).floatValue() * value;
            }
            if (map.get(SPD_STAT) != null) {
                spd = map.get(SPD_STAT).floatValue() * value;
            }
            if (map.get(MIN_STAT) != null) {
                min = map.get(MIN_STAT).floatValue() * value;
            }
            if (map.get(DEF_STAT) != null) {
                def = map.get(DEF_STAT).floatValue() * value;
            }
            if (map.get(RNG_STAT) != null) {
                rng = map.get(RNG_STAT).floatValue() * value;
            }
            if (map.get(SWP_STAT) != null) {
                swp = map.get(SWP_STAT).floatValue() * value;
            }
            if (map.get(DUR_STAT) != null) {
                dur = map.get(DUR_STAT).floatValue() * value;
            }
            if (stats.getElement() != null) {
                elm = stats.getElement();
            }
            if (stats.getMiningLevel() != null) {
                minLv = stats.getMiningLevel();
            }
            if (stats.getTier() > tier) {
                tier = stats.getTier();
            }
        }
        return new ToolStats(atk, elmAtk, spd, min, def, rng, swp, dur, elm, minLv, tier);
    }

    public static ToolStats mulWithoutElementCode(ToolStats stats, ToolStats value) {
        float atk = 0.0f;
        float elmAtk = 0.0f;
        float spd = 0.0f;
        float min = 0.0f;
        float def = 0.0f;
        float rng = 0.0f;
        float swp = 0.0f;
        float dur = 0.0f;
        HashMap elementMap = new HashMap();
        Element elm = Element.NONE;
        MiningLevel minLv = MiningLevel.NONE;
        int tier = 0;
        if (stats != null && value != null) {
            Map<String, Float> map = stats.getStats();
            Map<String, Float> map2 = value.getStats();
            if (map.get(ATK_STAT) != null && map2.get(ATK_STAT) != null) {
                atk = map.get(ATK_STAT).floatValue() * map2.get(ATK_STAT).floatValue();
            }
            if (map.get(ELM_ATK_STAT) != null && map2.get(ELM_ATK_STAT) != null) {
                elmAtk = map.get(ELM_ATK_STAT).floatValue() * map2.get(ELM_ATK_STAT).floatValue();
            }
            if (map.get(SPD_STAT) != null && map2.get(SPD_STAT) != null) {
                spd = map.get(SPD_STAT).floatValue() * map2.get(SPD_STAT).floatValue();
            }
            if (map.get(MIN_STAT) != null && map2.get(MIN_STAT) != null) {
                min = map.get(MIN_STAT).floatValue() * map2.get(MIN_STAT).floatValue();
            }
            if (map.get(DEF_STAT) != null && map2.get(DEF_STAT) != null) {
                def = map.get(DEF_STAT).floatValue() * map2.get(DEF_STAT).floatValue();
            }
            if (map.get(RNG_STAT) != null && map2.get(RNG_STAT) != null) {
                rng = map.get(RNG_STAT).floatValue() * map2.get(RNG_STAT).floatValue();
            }
            if (map.get(SWP_STAT) != null && map2.get(SWP_STAT) != null) {
                swp = map.get(SWP_STAT).floatValue() * map2.get(SWP_STAT).floatValue();
            }
            if (map.get(DUR_STAT) != null && map2.get(DUR_STAT) != null) {
                dur = map.get(DUR_STAT).floatValue() * map2.get(DUR_STAT).floatValue();
            }
            if (stats.getElement() != null) {
                elm = stats.getElement();
            }
            if (stats.getMiningLevel() != null) {
                minLv = stats.getMiningLevel();
            }
            if (stats.getTier() > tier) {
                tier = stats.getTier();
            }
        }
        return new ToolStats(atk, elmAtk, spd, min, def, rng, swp, dur, elm, minLv, tier);
    }

    public Map<String, Float> getStats() {
        return this.stats;
    }

    public Element getElement() {
        return this.element;
    }

    public MiningLevel getMiningLevel() {
        return this.miningLevel;
    }

    public int getTier() {
        return this.tier;
    }
}

