/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.material.MiningLevel;
import org.jetbrains.annotations.NotNull;

public class ToolStatsNew {
    public static final ToolStatsNew DEFAULT = new ToolStatsNew(Map.of(), Element.NONE, MiningLevel.NONE, 0);
    private final Map<StatsType, Float> statsMap;
    private final Element element;
    private final MiningLevel miningLevel;
    private final int tier;

    private ToolStatsNew(@NotNull Map<StatsType, Float> statsMap, @NotNull Element element, @NotNull MiningLevel miningLevel, int tier) {
        this.statsMap = statsMap;
        this.element = element;
        this.miningLevel = miningLevel;
        this.tier = tier;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static ToolStatsNew combine(@NotNull List<ToolStatsNew> others) {
        return ToolStatsNew.combineBuilder(others, true).build();
    }

    @NotNull
    public static ToolStatsNew combineWithoutElement(@NotNull List<ToolStatsNew> others) {
        return ToolStatsNew.combineBuilder(others, false).build();
    }

    @NotNull
    private static Builder combineBuilder(@NotNull List<ToolStatsNew> others, boolean includeElement) {
        Builder builder = ToolStatsNew.builder();
        HashMap<Element, Float> elementMap = new HashMap<Element, Float>();
        for (ToolStatsNew other : others) {
            other.statsMap.forEach(builder::addStats);
            Element element = other.getElement();
            float elementAttack = builder.getStats(StatsType.ELEMENT_ATTACK);
            elementMap.compute(element, (element1, aFloat) -> Float.valueOf(aFloat == null ? elementAttack : aFloat.floatValue() + elementAttack));
            MiningLevel miningLevel = other.getMiningLevel();
            if (miningLevel.getTier() > builder.miningLevel.getTier()) {
                builder.setMiningLevel(miningLevel);
            }
            builder.addTier(other.getTier());
        }
        if (!includeElement) {
            return builder;
        }
        float elementAttack = builder.getStats(StatsType.ELEMENT_ATTACK);
        List<Element> elements = List.of(Element.EMBER, Element.GLACE, Element.SURGE, Element.PHANTOM, Element.TREMOR, Element.MAGIC, Element.FLOW, Element.HOLLOW);
        for (Element element : elements) {
            if (elementMap.getOrDefault((Object)element, Float.valueOf(0.0f)).floatValue() > elementAttack) {
                builder.setElement(element);
                elementAttack = elementMap.getOrDefault((Object)element, Float.valueOf(0.0f)).floatValue();
                continue;
            }
            if (elementMap.getOrDefault((Object)element, Float.valueOf(0.0f)).floatValue() != elementAttack) continue;
            builder.setElement(Element.NONE);
            elementAttack = 0.0f;
        }
        Element currentElement = builder.getElement();
        for (Element element : elements) {
            if (element == currentElement) continue;
            elementAttack += elementMap.getOrDefault((Object)element, Float.valueOf(0.0f)).floatValue() * 0.75f;
        }
        ImmutableList elements1 = ImmutableList.builder().addAll(elements).add((Object)Element.NONE).build();
        for (Element element : elements1) {
            if (element == currentElement) continue;
            elementAttack += elementMap.getOrDefault((Object)element, Float.valueOf(0.0f)).floatValue() * (element == Element.NONE ? 1.0f : 0.5f);
        }
        builder.setStats(StatsType.ELEMENT_ATTACK, elementAttack);
        return builder;
    }

    public float getStat(@NotNull StatsType statsType) {
        return this.statsMap.getOrDefault((Object)statsType, Float.valueOf(0.0f)).floatValue();
    }

    @NotNull
    public Element getElement() {
        return this.element;
    }

    @NotNull
    public MiningLevel getMiningLevel() {
        return this.miningLevel;
    }

    public int getTier() {
        return this.tier;
    }

    public static class Builder {
        private final Map<StatsType, Float> builder = new HashMap<StatsType, Float>();
        private Element element = Element.NONE;
        private MiningLevel miningLevel = MiningLevel.NONE;
        private int tier = 0;

        Builder() {
        }

        public float getStats(StatsType statsType) {
            return this.builder.getOrDefault((Object)statsType, Float.valueOf(0.0f)).floatValue();
        }

        public Builder addStats(StatsType statsType, float value) {
            this.builder.compute(statsType, (statsType1, old) -> Float.valueOf(old != null ? old.floatValue() + value : value));
            return this;
        }

        public Builder setStats(StatsType statsType, float value) {
            this.builder.put(statsType, Float.valueOf(value));
            return this;
        }

        public Element getElement() {
            return this.element;
        }

        public Builder setElement(Element element) {
            this.element = element;
            return this;
        }

        public Builder setMiningLevel(MiningLevel miningLevel) {
            this.miningLevel = miningLevel;
            return this;
        }

        public Builder addTier(int tier) {
            this.tier += tier;
            return this;
        }

        public Builder setTier(int tier) {
            this.tier = tier;
            return this;
        }

        public ToolStatsNew build() {
            return new ToolStatsNew(Map.copyOf(this.builder), this.element, this.miningLevel, this.tier);
        }
    }

    public static enum StatsType implements StringRepresentable
    {
        ATTACK,
        ELEMENT_ATTACK,
        ATTACK_SPEED,
        MINING_SPEED,
        DEFENCE,
        ATTACK_RANGE,
        SWEEP_RANGE,
        DURABILITY;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

