/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.model;

import java.util.List;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.stln.magitech.MagitechRegistries;
import net.stln.magitech.item.tool.material.ToolMaterial;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PartToolItemModelRegister {
    private static final List<String> toolTypes = List.of("dagger", "light_sword", "heavy_sword", "pickaxe", "hammer", "axe", "shovel", "scythe", "spear", "wand", "staff");
    private static final List<String> partTypes = List.of("light_blade", "heavy_blade", "light_handle", "heavy_handle", "tool_binding", "handguard", "strike_head", "spike_head", "reinforced_stick", "plate", "catalyst", "conductor");
    public static ModelResolver ToolPartItemModelResolver = context -> {
        if (context.id().getNamespace().equals("magitech")) {
            if (context.id().getPath().contains("heavy_sword") || context.id().getPath().contains("hammer") || context.id().getPath().contains("scythe") || context.id().getPath().contains("spear") || context.id().getPath().contains("staff")) {
                return PartToolItemModelRegister.getHeavyToolUnbakedModel(context.id());
            }
            return PartToolItemModelRegister.getUnbakedModel(context.id());
        }
        return null;
    };

    public static void register() {
        ModelLoadingPlugin.register(pluginContext -> {
            MagitechRegistries.TOOL_MATERIAL.stream().forEach(toolMaterial -> {
                for (String toolType : toolTypes) {
                    for (String partType : partTypes) {
                        pluginContext.addModels(new ResourceLocation[]{PartToolItemModelRegister.getPartModelId(toolMaterial, toolType, partType)});
                    }
                }
            });
            Event resolverEvent = pluginContext.resolveModel();
            resolverEvent.register((Object)ToolPartItemModelResolver);
        });
    }

    @NotNull
    private static UnbakedModel getHeavyToolUnbakedModel(ResourceLocation identifier) {
        return BlockModel.fromString((String)("{\n    \"parent\": \"magitech:item/heavy_tool\",\n    \"textures\": {\n        \"layer0\": \"" + identifier.toString() + "\"\n    }\n}"));
    }

    @NotNull
    private static UnbakedModel getUnbakedModel(ResourceLocation identifier) {
        return BlockModel.fromString((String)("{\n    \"parent\": \"item/handheld\",\n    \"textures\": {\n        \"layer0\": \"" + identifier.toString() + "\"\n    }\n}"));
    }

    private static ResourceLocation getPartModelId(ToolMaterial toolMaterial, String toolType, String part) {
        return ResourceLocation.fromNamespaceAndPath((String)toolMaterial.getId().getNamespace(), (String)("item/tool/" + toolType + "/" + toolMaterial.getId().getPath() + "_" + part));
    }
}

