/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.toolitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.AdjustableAttackStrengthEntity;
import net.stln.magitech.gui.toast.TierUpToast;
import net.stln.magitech.item.LeftClickOverrideItem;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.tool.ToolPart;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.ToolType;
import net.stln.magitech.item.tool.material.MiningLevel;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.item.tool.register.ToolMaterialRegister;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.item.tool.upgrade.UpgradeInstance;
import net.stln.magitech.network.TierUpToastPayload;
import net.stln.magitech.network.TraitTickPayload;
import net.stln.magitech.particle.particle_option.BlowParticleEffect;
import net.stln.magitech.particle.particle_option.FlameParticleEffect;
import net.stln.magitech.particle.particle_option.FrostParticleEffect;
import net.stln.magitech.particle.particle_option.MembraneParticleEffect;
import net.stln.magitech.particle.particle_option.RuneParticleEffect;
import net.stln.magitech.particle.particle_option.SparkParticleEffect;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.particle.particle_option.VoidGlowParticleEffect;
import net.stln.magitech.particle.particle_option.WaveParticleEffect;
import net.stln.magitech.util.ColorHelper;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.DataMapHelper;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.MathUtil;
import net.stln.magitech.util.RenderHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class PartToolItem
extends Item
implements LeftClickOverrideItem {
    ResourceLocation atkId = Magitech.id("part_tool_attack_damage_modifier");
    ResourceLocation spdId = Magitech.id("part_tool_attack_speed_modifier");
    ResourceLocation defId = Magitech.id("part_tool_defense_modifier");
    ResourceLocation rngId = Magitech.id("part_tool_attack_range_modifier");

    public PartToolItem(Item.Properties settings) {
        super(settings);
    }

    public static ToolStats getDefaultStats(ItemStack stack) {
        List<ToolMaterial> materials = ComponentHelper.getPartMaterials((DataComponentHolder)stack);
        if (!materials.isEmpty()) {
            ToolType toolType = ((PartToolItem)stack.getItem()).getToolType();
            ArrayList<ToolStats> stats = new ArrayList<ToolStats>();
            ToolStats base = ToolMaterialRegister.getBaseStats(toolType);
            for (int i = 0; i < materials.size(); ++i) {
                ToolMaterial toolMaterial = materials.get(i);
                ToolPart toolPart = ToolMaterialRegister.getToolPartFromIndex(toolType, i);
                float value = 0.0f;
                if (toolPart != null) {
                    value = ((PartToolItem)stack.getItem()).getMultiplier(toolPart);
                }
                if (!(stack.getItem() instanceof SpellCasterItem)) {
                    stats.add(ToolStats.mulWithoutElementCode(ToolStats.mulWithoutElementCode(toolMaterial.stats(), base), value));
                    continue;
                }
                stats.add(ToolStats.mulWithoutElementCode(ToolStats.mulWithoutElementCode(toolMaterial.spellCasterStats(), base), value));
            }
            return ToolStats.add(stats);
        }
        return ToolStats.DEFAULT;
    }

    public static ToolStats getBaseStats(ItemStack stack) {
        ToolStats stats = PartToolItem.getDefaultStats(stack);
        if (!stack.has(ComponentInit.BROKEN_COMPONENT)) {
            stack.set(ComponentInit.BROKEN_COMPONENT, (Object)false);
        }
        ToolType toolType = ((PartToolItem)stack.getItem()).getToolType();
        List<UpgradeInstance> upgrades = ComponentHelper.getUpgrades((DataComponentHolder)stack);
        ArrayList<ToolStats> upgradeStats = new ArrayList<ToolStats>();
        for (UpgradeInstance upgrade : upgrades) {
            upgradeStats.add(ToolStats.mulWithoutElementCode(ToolMaterialRegister.getBaseStats(toolType), upgrade.upgrade().getUpgradeStats(upgrade.level())));
        }
        upgradeStats.add(stats);
        return ToolStats.add(upgradeStats);
    }

    @NotNull
    public static Set<ToolMaterial> getMaterialSet(@NotNull List<ToolMaterial> materials) {
        return new HashSet<ToolMaterial>(materials);
    }

    public static List<Trait> getTraits(ItemStack stack) {
        return ComponentHelper.getPartMaterials((DataComponentHolder)stack).stream().map(ToolMaterial::trait).toList();
    }

    @NotNull
    public static Map<Trait, Integer> getTraitLevel(List<Trait> traits) {
        HashMap<Trait, Integer> traitLevel = new HashMap<Trait, Integer>();
        for (Trait trait : traits) {
            if (trait == null) continue;
            traitLevel.put(trait, traitLevel.getOrDefault(trait, 0) + 1);
        }
        return traitLevel;
    }

    private static boolean hasCorrectTier(ItemStack stack, BlockState state, ToolStats stats) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return false;
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_NETHERITE_TOOL)) && stats.getMiningLevel().getTier() <= MiningLevel.NETHERITE.getTier()) {
            return false;
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_DIAMOND_TOOL)) && stats.getMiningLevel().getTier() <= MiningLevel.DIAMOND.getTier()) {
            return false;
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_IRON_TOOL)) && stats.getMiningLevel().getTier() <= MiningLevel.IRON.getTier()) {
            return false;
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_STONE_TOOL)) && stats.getMiningLevel().getTier() <= MiningLevel.STONE.getTier()) {
            return false;
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_GOLD_TOOL)) && stats.getMiningLevel().getTier() <= MiningLevel.NONE.getTier()) {
            return false;
        }
        return !state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_WOODEN_TOOL)) || stats.getMiningLevel().getTier() > MiningLevel.NONE.getTier();
    }

    public static Direction getBreakDirection(double range, BlockPos initalBlockPos, Player player) {
        ArrayList positions = new ArrayList();
        BlockHitResult traceResult = player.level().clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue())), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return traceResult.getDirection();
    }

    protected static void addDefaultComponents(@NotNull ItemStack stack, List<Component> tooltipComponents) {
        tooltipComponents.add((Component)Component.empty());
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.broken").withColor(0xFF8080));
        }
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.tier").append(" ").append(String.valueOf(ComponentHelper.getTier((DataComponentHolder)stack))).withColor(ColorHelper.getTierColor(ComponentHelper.getTier((DataComponentHolder)stack))));
        tooltipComponents.add(RenderHelper.getGradationGauge(0, (Integer)stack.getOrDefault(ComponentInit.MAX_PROGRESSION_COMPONENT, (Object)0), (Integer)stack.getOrDefault(ComponentInit.PROGRESSION_COMPONENT, (Object)0), 30, ColorHelper.getTierColor(ComponentHelper.getTier((DataComponentHolder)stack)), ColorHelper.getTierColor(ComponentHelper.getTier((DataComponentHolder)stack) + 1)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.progress").withColor(0xA0A0A0).append(": ").append((Component)Component.literal((String)String.valueOf(stack.getOrDefault(ComponentInit.PROGRESSION_COMPONENT, (Object)0))).withColor(0xFFFFFF)).append(" / ").append((Component)Component.literal((String)String.valueOf(stack.getOrDefault(ComponentInit.MAX_PROGRESSION_COMPONENT, (Object)0))).withColor(ColorHelper.getTierColor(ComponentHelper.getTier((DataComponentHolder)stack)))));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.upgrade_point").withColor(0xA0A0A0).append(": ").append((Component)Component.literal((String)String.valueOf(ComponentHelper.getUpgradePoint((DataComponentHolder)stack))).withColor(12648288)));
    }

    public static void progress(ItemStack stack, Level level, Entity entity) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return;
        }
        if (stack.has(ComponentInit.PROGRESSION_COMPONENT)) {
            stack.set(ComponentInit.PROGRESSION_COMPONENT, (Object)((Integer)stack.getOrDefault(ComponentInit.PROGRESSION_COMPONENT, (Object)0) + 1));
            if ((Integer)stack.getOrDefault(ComponentInit.PROGRESSION_COMPONENT, (Object)0) >= (Integer)stack.getOrDefault(ComponentInit.MAX_PROGRESSION_COMPONENT, (Object)0)) {
                int tier = ComponentHelper.getTier((DataComponentHolder)stack);
                stack.set(ComponentInit.TIER_COMPONENT, (Object)(tier + 1));
                ComponentHelper.updateUpgradePoint((MutableDataComponentHolder)stack, value -> value + 1);
                stack.set(ComponentInit.PROGRESSION_COMPONENT, (Object)0);
                stack.set(ComponentInit.MAX_PROGRESSION_COMPONENT, (Object)PartToolItem.getMaxProgression(tier + 1));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!level.isClientSide) {
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new TierUpToastPayload(player.getInventory().findSlotMatchingItem(stack), tier + 1, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addToast(ItemStack stack, int tier) {
        Minecraft.getInstance().getToasts().addToast((Toast)new TierUpToast(tier, stack.copy()));
    }

    private static int getMaxProgression(int level) {
        return (int)Math.round(100.0 * Math.exp(Math.log(3.0) * Math.sqrt(level) / Math.sqrt(5.0)));
    }

    public ToolStats getSumStats(Player player, Level level, ItemStack stack) {
        return this.getModifiedStats(player, level, stack);
    }

    public ToolStats getModifiedStats(Player player, Level level, ItemStack stack) {
        Map<Trait, Integer> traits = PartToolItem.getTraitLevel(PartToolItem.getTraits(stack));
        ArrayList<ToolStats> statsList = new ArrayList<ToolStats>();
        statsList.add(PartToolItem.getBaseStats(stack));
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifyStats1(stack, (int)value, PartToolItem.getBaseStats(stack)));
                statsList.add(trait.modifyStatsConditional1(player, level, stack, (int)value, PartToolItem.getBaseStats(stack)));
            }
        });
        ToolStats stats1 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifyStats2(stack, (int)value, stats1));
                statsList.add(trait.modifyStatsConditional2(player, level, stack, (int)value, stats1));
            }
        });
        ToolStats stats2 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifyStats3(stack, (int)value, stats2));
                statsList.add(trait.modifyStatsConditional3(player, level, stack, (int)value, stats2));
            }
        });
        return ToolStats.add(statsList);
    }

    public ToolStats getSumStatsWithoutConditional(ItemStack stack) {
        return this.getModifiedStatsWithoutConditional(stack);
    }

    public ToolStats getModifiedStatsWithoutConditional(ItemStack stack) {
        Map<Trait, Integer> traits = PartToolItem.getTraitLevel(PartToolItem.getTraits(stack));
        ArrayList<ToolStats> statsList = new ArrayList<ToolStats>();
        statsList.add(PartToolItem.getBaseStats(stack));
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifyStats1(stack, (int)value, PartToolItem.getBaseStats(stack)));
            }
        });
        ToolStats stats1 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifyStats2(stack, (int)value, stats1));
            }
        });
        ToolStats stats2 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifyStats3(stack, (int)value, stats2));
            }
        });
        return ToolStats.add(statsList);
    }

    public boolean isCorrectTool(ItemStack stack, BlockState state, PartToolItem partToolItem, ToolStats stats) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return false;
        }
        Boolean[] flag = new Boolean[]{null};
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> {
            Boolean isCorrect = trait.isCorrectTool(stack, (int)integer, this.getModifiedStatsWithoutConditional(stack), state);
            if (isCorrect != null) {
                flag[0] = isCorrect;
                if (!isCorrect.booleanValue()) {
                    return;
                }
            }
        });
        if (flag[0] != null) {
            return flag[0];
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.MINEABLE_WITH_AXE)) && partToolItem.getToolType() == ToolType.AXE) {
            return PartToolItem.hasCorrectTier(stack, state, stats);
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.MINEABLE_WITH_PICKAXE)) && (partToolItem.getToolType() == ToolType.PICKAXE || partToolItem.getToolType() == ToolType.HAMMER)) {
            return PartToolItem.hasCorrectTier(stack, state, stats);
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.MINEABLE_WITH_SHOVEL)) && partToolItem.getToolType() == ToolType.SHOVEL) {
            return PartToolItem.hasCorrectTier(stack, state, stats);
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.MINEABLE_WITH_HOE)) && partToolItem.getToolType() == ToolType.SCYTHE) {
            return PartToolItem.hasCorrectTier(stack, state, stats);
        }
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.SWORD_EFFICIENT)) && (partToolItem.getToolType() == ToolType.DAGGER || partToolItem.getToolType() == ToolType.LIGHT_SWORD || partToolItem.getToolType() == ToolType.HEAVY_SWORD || partToolItem.getToolType() == ToolType.SCYTHE)) {
            return PartToolItem.hasCorrectTier(stack, state, stats);
        }
        return false;
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return false;
        }
        PartToolItem partToolItem = (PartToolItem)stack.getItem();
        if (ItemAbilities.DEFAULT_AXE_ACTIONS.contains(itemAbility) && partToolItem.getToolType() == ToolType.AXE) {
            return true;
        }
        if (ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(itemAbility) && (partToolItem.getToolType() == ToolType.PICKAXE || partToolItem.getToolType() == ToolType.HAMMER)) {
            return true;
        }
        if (ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(itemAbility) && partToolItem.getToolType() == ToolType.SHOVEL) {
            return true;
        }
        if (ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility) && partToolItem.getToolType() == ToolType.SCYTHE) {
            return true;
        }
        if (ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility) && (partToolItem.getToolType() == ToolType.DAGGER || partToolItem.getToolType() == ToolType.LIGHT_SWORD || partToolItem.getToolType() == ToolType.HEAVY_SWORD || partToolItem.getToolType() == ToolType.SCYTHE)) {
            return true;
        }
        return super.canPerformAction(stack, itemAbility);
    }

    public abstract ToolType getToolType();

    public abstract float getMultiplier(ToolPart var1);

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            player = (Player)entity;
            if (player.getItemInHand(InteractionHand.MAIN_HAND) == stack || player.getItemInHand(InteractionHand.OFF_HAND) == stack) {
                PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.tick(player, world, stack, (int)integer, PartToolItem.getBaseStats(stack), true));
                if (world.isClientSide) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new TraitTickPayload(player.getItemInHand(InteractionHand.MAIN_HAND) == stack, false, slot, entity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.inventoryTick(player, world, stack, (int)integer, PartToolItem.getBaseStats(stack), true));
            if (world.isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TraitTickPayload(player.getItemInHand(InteractionHand.MAIN_HAND) == stack, true, slot, entity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            this.reloadComponent(player, world, stack);
        }
    }

    public void onCraftedPostProcess(@NotNull ItemStack stack, @NotNull Level level) {
        super.onCraftedPostProcess(stack, level);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        MutableComponent component = Component.empty();
        List<ToolMaterial> materials = ComponentHelper.getPartMaterials((DataComponentHolder)stack);
        Item item = stack.getItem();
        if (item instanceof PartToolItem) {
            PartToolItem partToolItem = (PartToolItem)item;
            ToolType toolType = partToolItem.getToolType();
            ToolMaterial firstMaterial = materials.getFirst();
            ToolMaterial secondMaterial = materials.get(1);
            if (materials.size() == toolType.getSize() && firstMaterial != null && secondMaterial != null) {
                if (Objects.equals(firstMaterial, secondMaterial)) {
                    component.append((Component)Component.translatable((String)("item.magitech." + toolType.getId() + ".simple"), (Object[])new Object[]{firstMaterial.getDescription()}));
                } else {
                    component.append((Component)Component.translatable((String)("item.magitech." + toolType.getId() + ".complex"), (Object[])new Object[]{firstMaterial.getDescription(), secondMaterial.getDescription()}));
                }
            } else {
                component.append((Component)Component.translatable((String)("item.magitech." + ((PartToolItem)stack.getItem()).getToolType().getId())));
            }
        }
        return component;
    }

    public void reloadComponent(Player player, Level level, ItemStack stack) {
        ArrayList<ItemAttributeModifiers.Entry> entries = new ArrayList<ItemAttributeModifiers.Entry>();
        ToolStats finalStats = this.getSumStats(player, level, stack);
        Map<String, Float> map = finalStats.getStats();
        stack.set(ComponentInit.BROKEN_COMPONENT, (Object)(stack.getDamageValue() + 1 >= stack.getMaxDamage() ? 1 : 0));
        if (!ComponentHelper.isBroken((DataComponentHolder)stack)) {
            entries.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(this.atkId, (double)map.get(ToolStats.ATK_STAT).floatValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
            entries.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(this.spdId, (double)(map.get(ToolStats.SPD_STAT).floatValue() - 4.0f), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
            entries.add(new ItemAttributeModifiers.Entry(Attributes.ARMOR, new AttributeModifier(this.defId, (double)map.get(ToolStats.DEF_STAT).floatValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
            entries.add(new ItemAttributeModifiers.Entry(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(this.rngId, (double)(map.get(ToolStats.RNG_STAT).floatValue() - 3.0f), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        }
        this.modifyTraitAttribute(player, level, stack, finalStats, entries);
        ItemAttributeModifiers component = new ItemAttributeModifiers(entries, false);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)component);
        this.setTier(stack, finalStats);
        if ((float)stack.getMaxDamage() != map.get(ToolStats.DUR_STAT).floatValue()) {
            int newMaxDamage = Math.round(map.get(ToolStats.DUR_STAT).floatValue());
            int oldMaxDamage = stack.getMaxDamage();
            int oldDamage = stack.getDamageValue();
            if (newMaxDamage <= 0) {
                newMaxDamage = 1;
            }
            stack.set(DataComponents.MAX_DAMAGE, (Object)newMaxDamage);
            stack.setDamageValue((int)((float)oldDamage * (float)newMaxDamage / (float)oldMaxDamage));
        }
    }

    protected void setTier(ItemStack stack, ToolStats finalStats) {
        stack.update(ComponentInit.TIER_COMPONENT, (Object)(finalStats.getTier() * 5 / this.getToolType().getSize()), UnaryOperator.identity());
        ComponentHelper.updateUpgradePoint((MutableDataComponentHolder)stack, value -> Math.max(0, value - finalStats.getTier() * 5 / this.getToolType().getSize()));
        stack.update(ComponentInit.PROGRESSION_COMPONENT, (Object)0, UnaryOperator.identity());
        stack.update(ComponentInit.MAX_PROGRESSION_COMPONENT, (Object)PartToolItem.getMaxProgression(ComponentHelper.getTier((DataComponentHolder)stack)), UnaryOperator.identity());
    }

    protected void modifyTraitAttribute(Player player, Level level, ItemStack stack, ToolStats finalStats, List<ItemAttributeModifiers.Entry> entries) {
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, value) -> trait.modifyAttribute(player, level, stack, (int)value, finalStats, entries));
    }

    public void postHurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        PartToolItem.progress(stack, attacker.level(), (Entity)attacker);
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return false;
        }
        ToolStats stats = this.getSumStatsWithoutConditional(stack);
        return this.isCorrectTool(stack, state, (PartToolItem)stack.getItem(), stats);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (stack.getMaxDamage() - stack.getDamageValue() - 1 <= amount) {
            if (stack.getMaxDamage() - stack.getDamageValue() <= amount) {
                return 0;
            }
            if (entity != null && !ComponentHelper.isBroken((DataComponentHolder)stack)) {
                entity.level().playSound(null, entity.getOnPos(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            stack.set(ComponentInit.BROKEN_COMPONENT, (Object)true);
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        this.addStatsHoverText(stack, tooltipComponents);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void addStatsHoverText(@NotNull ItemStack stack, List<Component> tooltipComponents) {
        ToolStats finalStats = this.getSumStatsWithoutConditional(stack);
        this.setTier(stack, finalStats);
        PartToolItem.addDefaultComponents(stack, tooltipComponents);
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.attack_damage").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.ATK_STAT).floatValue() + 1.0f, 2))).withColor(0xFF4040)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.elemental_damage").append(": ").withColor(0xA0A0A0).append((Component)Component.translatable((String)("element.magitech." + finalStats.getElement().get())).append(" ").append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue(), 2)))).withColor(finalStats.getElement().getColor())));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.attack_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.SPD_STAT).floatValue(), 2))).withColor(4259776)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.mining_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.MIN_STAT).floatValue(), 2))).withColor(4227264)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.defense").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.DEF_STAT).floatValue(), 2))).withColor(0xA0C0C0)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.attack_range").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.RNG_STAT).floatValue(), 2))).withColor(8438015)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.sweep_range").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.SWP_STAT).floatValue(), 2))).withColor(0xFFFF80)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.durability").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)(Math.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue()) - stack.getDamageValue() - 1 + " / " + Math.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue() - 1.0f))).withColor(0xFFFFFF)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.mining_level").append(": ").withColor(0xA0A0A0).append((Component)Component.translatable((String)("attribute.magitech.mining_level." + finalStats.getMiningLevel().get())).withColor(finalStats.getMiningLevel().getColor())));
        tooltipComponents.add((Component)Component.empty());
        Map<Trait, Integer> traitIntegerMap = PartToolItem.getTraitLevel(PartToolItem.getTraits(stack));
        traitIntegerMap.forEach((trait, integer) -> {
            if (trait != null) {
                MutableComponent component = trait.getComponent().append(" ");
                if (integer < 6 && trait.getMaxLevel() != 1) {
                    for (int i = 0; i < (trait.getMaxLevel() == -1 ? integer : Math.min(integer, trait.getMaxLevel())); ++i) {
                        component.append("|");
                    }
                } else if (trait.getMaxLevel() != 1) {
                    component.append(integer.toString());
                }
                tooltipComponents.add((Component)component);
            }
        });
    }

    public void traitAction(Level level, Player player, InteractionHand usedHand) {
        double mul;
        Vec3 forward;
        Vec3 maxReachPos;
        if (ComponentHelper.isBroken((DataComponentHolder)player.getItemInHand(usedHand))) {
            return;
        }
        ItemStack stack = player.getItemInHand(usedHand);
        Vec3 playerEyePos = player.getEyePosition();
        EntityHitResult result = EntityUtil.getEntityHitResult((Entity)player, playerEyePos, maxReachPos = playerEyePos.add((forward = Vec3.directionFromRotation((Vec2)player.getRotationVector())).multiply(mul = 256.0, mul, mul)), level);
        if (result != null) {
            PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.traitAction(player, level, result.getEntity(), result.getLocation(), stack, (int)integer, this.getSumStats(player, level, stack), usedHand, true));
        } else {
            PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.traitAction(player, level, null, new Vec3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE), stack, (int)integer, this.getSumStats(player, level, stack), usedHand, true));
        }
    }

    @Override
    public InteractionResult onLeftClick(Player user, InteractionHand hand, Level world) {
        double mul;
        Vec3 forward;
        Vec3 maxReachPos;
        if (ComponentHelper.isBroken((DataComponentHolder)user.getItemInHand(hand))) {
            return InteractionResult.PASS;
        }
        Vec3 playerEyePos = user.getEyePosition(1.0f);
        if (EntityUtil.getEntityHitResult((Entity)user, playerEyePos, maxReachPos = playerEyePos.add((forward = Vec3.directionFromRotation((Vec2)user.getRotationVector())).multiply(mul = user.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), mul, mul)), world) != null || PartToolItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.NONE).getType() != HitResult.Type.BLOCK) {
            if (user.getAttackStrengthScale(0.5f) > 0.7f) {
                world.playSound(user, user.getX(), user.getY(), user.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, this.getSumStats(user, world, user.getItemInHand(hand)).getStats().get(ToolStats.SPD_STAT).floatValue() / 2.0f);
                this.sweepAttack(world, hand, user);
            } else {
                world.playSound(user, user.getX(), user.getY(), user.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, SoundSource.PLAYERS, 1.0f, this.getSumStats(user, world, user.getItemInHand(hand)).getStats().get(ToolStats.SPD_STAT).floatValue() / 2.0f);
            }
            user.swing(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        List<Trait> traits = PartToolItem.getTraits(stack);
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(1, (ServerLevel)level, miningEntity, item -> {});
            PartToolItem.progress(stack, level, (Entity)miningEntity);
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public void sweepAttack(Level world, InteractionHand hand, Player user) {
        ItemStack stack = user.getItemInHand(hand);
        ToolStats stats = this.getSumStats(user, world, stack);
        float swp = stats.getStats().get(ToolStats.SWP_STAT).floatValue();
        Vec3 effectCenter = EntityUtil.getAttackTargetPosition(user, user.entityInteractionRange(), 0.5, swp * 0.7f);
        float red = (float)((stats.getElement().getColor() & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((stats.getElement().getColor() & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(stats.getElement().getColor() & 0xFF) / 255.0f;
        float red2 = red * red;
        float green2 = green * green;
        float blue2 = blue * blue;
        if (stats.getElement() == Element.EMBER) {
            EffectUtil.sweepEffect(user, world, new FlameParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.GLACE) {
            EffectUtil.sweepEffect(user, world, new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.SURGE) {
            EffectUtil.sweepEffect(user, world, new SparkParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 3, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.PHANTOM) {
            EffectUtil.sweepEffect(user, world, new MembraneParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.TREMOR) {
            EffectUtil.sweepEffect(user, world, new WaveParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.MAGIC) {
            EffectUtil.sweepEffect(user, world, new RuneParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.FLOW) {
            EffectUtil.sweepEffect(user, world, new BlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else if (stats.getElement() == Element.HOLLOW) {
            EffectUtil.sweepEffect(user, world, new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), 0.0, effectCenter, -45.0, 45.0, 50, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        } else {
            EffectUtil.sweepEffect(user, world, new SquareParticleEffect(new Vector3f(red, green, blue), new Vector3f(red2, green2, blue2), 1.0f, 1, 0.0f), 0.01, effectCenter, -45.0, 45.0, 100, swp * 0.7f, ((double)user.getRandom().nextFloat() - 0.5) * 45.0, false);
        }
        Vec3 center = EntityUtil.getAttackTargetPosition(user, user.entityInteractionRange(), 2.0, 0.0);
        List<Entity> attackList = EntityUtil.getEntitiesInBox(world, (Entity)user, center, new Vec3((double)swp, (double)(swp / 3.0f), (double)swp));
        attackList.removeIf(e -> {
            if (!(e instanceof LivingEntity)) return true;
            LivingEntity livingEntity = (LivingEntity)e;
            if (e == user) return true;
            if (!user.canAttack(livingEntity)) return true;
            if (!e.isInvulnerable()) return false;
            return true;
        });
        float cooldown = ((AdjustableAttackStrengthEntity)user).getLastAttackedTicks();
        for (Entity target : attackList) {
            if (!target.isAttackable()) continue;
            ((AdjustableAttackStrengthEntity)user).setLastAttackedTicks((int)cooldown);
            this.applyElementDamage(user, target, stack);
            user.attack(target);
            this.callTraitAttackEntity(world, user, target, stack);
        }
        if (!attackList.isEmpty() && !user.level().isClientSide) {
            stack.hurtAndBreak(1, (LivingEntity)user, EquipmentSlot.MAINHAND);
            PartToolItem.progress(stack, world, (Entity)user);
        }
        user.resetAttackStrengthTicker();
    }

    public void applyElementDamage(Player attacker, Entity target, ItemStack stack) {
        ResourceKey<DamageType> damageType = this.getSumStats(attacker, attacker.level(), stack).getElement().getDamageType();
        if (damageType != null) {
            boolean bl3;
            ToolStats stats = this.getSumStats(attacker, attacker.level(), stack);
            float baseAttackDamage = stats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue();
            float h = attacker.getAttackStrengthScale(0.5f);
            baseAttackDamage *= 0.2f + h * h * 0.8f;
            boolean bl = bl3 = h > 0.9f && attacker.fallDistance > 0.0f && !attacker.onGround() && !attacker.onClimbable() && !attacker.isInWater() && !attacker.hasEffect(MobEffects.BLINDNESS) && attacker.getVehicle() == null && target instanceof LivingEntity && !attacker.isSprinting();
            if (bl3) {
                baseAttackDamage *= 1.5f;
            }
            DamageSource elementalDamageSource = attacker.damageSources().source(damageType, (Entity)attacker);
            float damage = baseAttackDamage * DataMapHelper.getElementMultiplier(target, stats.getElement());
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                float targetHealth = livingEntity.getHealth();
                if (!target.isInvulnerableTo(elementalDamageSource)) {
                    livingEntity.setLastHurtByPlayer(attacker);
                    attacker.awardStat(Stats.DAMAGE_DEALT, Math.round((targetHealth - livingEntity.getHealth()) * 10.0f));
                }
                target.hurt(elementalDamageSource, damage);
            } else {
                Vec3 delta = target.getDeltaMovement();
                target.hurt(elementalDamageSource, damage);
                target.setDeltaMovement(delta);
            }
            target.invulnerableTime = 0;
        }
    }

    public int getEnchantmentLevel(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return super.getEnchantmentLevel(stack, enchantment);
        }
        int level = super.getEnchantmentLevel(stack, enchantment);
        int[] add = new int[]{0};
        int[] enhance = new int[]{0};
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> {
            add[0] = Math.max(add[0], trait.addEnchantments(stack, (int)integer, PartToolItem.getBaseStats(stack), enchantment, level));
        });
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> {
            enhance[0] = enhance[0] + trait.enhanceEnchantments(stack, (int)integer, PartToolItem.getBaseStats(stack), enchantment, add[0] + level);
        });
        return Math.max(0, level + add[0] + enhance[0]);
    }

    public void callTraitAttackEntity(Level world, Player user, Entity target, ItemStack stack) {
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.onAttackEntity(user, world, stack, (int)integer, this.getModifiedStats(user, world, stack), target));
    }

    public void callTraitSpellHitEntity(Level world, Player user, Entity target, ItemStack stack) {
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.onSpellHitEntity(user, world, stack, (int)integer, this.getModifiedStats(user, world, stack), target));
    }

    public void callTraitDamageEntity(Level world, Player user, Entity target, ItemStack stack) {
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.onDamageEntity(user, world, stack, (int)integer, this.getModifiedStats(user, world, stack), target));
    }

    public void callTestRepair(Level world, Player user, int amount, ItemStack stack) {
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.testRepair(user, world, stack, (int)integer, this.getModifiedStats(user, world, stack), amount));
    }

    public void callOnRepair(Level world, Player user, int amount, ItemStack stack) {
        PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.onRepair(user, world, stack, (int)integer, this.getModifiedStats(user, world, stack), amount));
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }
}

