/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class BrillianceTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        level.updateSkyBrightness();
        int light = level.getMaxLocalRawBrightness(player.blockPosition());
        if (light >= 10) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.25f;
            Float swp = stats.getStats().get(ToolStats.SWP_STAT);
            modified.put(ToolStats.SWP_STAT, Float.valueOf(swp.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifyStatsConditional1(player, level, stack, traitLevel, stats);
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        level.updateSkyBrightness();
        int light = level.getMaxLocalRawBrightness(player.blockPosition());
        if (light >= 10) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.25f;
            Float swp = stats.getStats().get(ToolStats.SWP_STAT);
            Float min = stats.getStats().get(ToolStats.MIN_STAT);
            modified.put(ToolStats.SWP_STAT, Float.valueOf(swp.floatValue() * mul));
            modified.put(ToolStats.MIN_STAT, Float.valueOf(min.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifySpellCasterStatsConditional1(player, level, stack, traitLevel, stats);
    }

    @Override
    public float modifyMiningSpeed(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos) {
        level.updateSkyBrightness();
        int light = level.getMaxLocalRawBrightness(player.blockPosition());
        if (light >= 10) {
            float mul = (float)traitLevel * 0.25f;
            Float min = stats.getStats().get(ToolStats.MIN_STAT);
            return min.floatValue() * mul;
        }
        return super.modifyMiningSpeed(player, level, stack, traitLevel, stats, blockState, pos);
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        super.tick(player, level, stack, traitLevel, stats, isHost);
        level.updateSkyBrightness();
        int light = level.getMaxLocalRawBrightness(player.blockPosition());
        if (light <= 3) {
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.85f, 0.8f, 1.0f), new Vector3f(0.85f, 0.8f, 1.0f), 1.0f, 1, 0.0f), (Entity)player, 1);
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 220, 0, false, false));
        } else if (light >= 10) {
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.85f, 0.8f, 1.0f), new Vector3f(0.85f, 0.8f, 1.0f), 1.0f, 1, 0.0f), (Entity)player, 1);
        }
    }

    @Override
    public int getColor() {
        return 14209279;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.brilliance");
    }
}

