/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.entity.mob_effect.MobEffectInit;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.TraitMobEffectHelper;
import org.joml.Vector3f;

public class ElectrostaticChargeTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        super.modifyStatsConditional1(player, level, stack, traitLevel, stats);
        ToolStats defaultStats = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(defaultStats.getStats());
        if (player.hasEffect(MobEffectInit.CHARGE)) {
            float mul = (float)traitLevel * 0.25f;
            modified.put(ToolStats.ELM_ATK_STAT, Float.valueOf(stats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue() * mul));
            modified.put(ToolStats.MIN_STAT, Float.valueOf(stats.getStats().get(ToolStats.MIN_STAT).floatValue() * mul));
        }
        return new ToolStats(modified, defaultStats.getElement(), defaultStats.getMiningLevel(), defaultStats.getTier());
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        super.modifySpellCasterStatsConditional1(player, level, stack, traitLevel, stats);
        ToolStats defaultStats = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(defaultStats.getStats());
        if (player.hasEffect(MobEffectInit.CHARGE)) {
            float mul = (float)traitLevel * 0.25f;
            modified.put(ToolStats.ELM_ATK_STAT, Float.valueOf(stats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue() * mul));
            modified.put(ToolStats.CLD_STAT, Float.valueOf(stats.getStats().get(ToolStats.CLD_STAT).floatValue() * mul));
        }
        return new ToolStats(modified, defaultStats.getElement(), defaultStats.getMiningLevel(), defaultStats.getTier());
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        super.tick(player, level, stack, traitLevel, stats, isHost);
        if (player.hasEffect(MobEffectInit.CHARGE)) {
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.75f, 0.9f, 0.6f), new Vector3f(0.65f, 0.9f, 0.4f), 1.0f, 1, 0.0f), (Entity)player, 1);
        }
    }

    @Override
    public void onDamageEntity(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, Entity target) {
        super.onDamageEntity(player, level, stack, traitLevel, stats, target);
        if (!level.isClientSide) {
            TraitMobEffectHelper.updateTraitMobEffectDuration((LivingEntity)player, MobEffectInit.CHARGE, 40 + traitLevel * 60);
        }
    }

    @Override
    public void onBreakBlock(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.onBreakBlock(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        if (!level.isClientSide) {
            TraitMobEffectHelper.updateTraitMobEffectDuration((LivingEntity)player, MobEffectInit.CHARGE, 40 + traitLevel * 60);
        }
    }

    @Override
    public int getColor() {
        return 12112032;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.electrostatic_charge");
    }
}

