/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.ToolType;
import net.stln.magitech.item.tool.toolitem.PartToolItem;

@EventBusSubscriber(modid="magitech")
public class ModifyBreakSpeedEvent {
    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        ToolStats stats;
        PartToolItem partToolItem;
        Player player = event.getEntity();
        Level level = player.level();
        float defaultSpeed = event.getOriginalSpeed();
        Optional blockPosOptional = event.getPosition();
        BlockState state = event.getState();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Direction direction = PartToolItem.getBreakDirection(player.blockInteractionRange(), blockPosOptional.orElse(BlockPos.ZERO), player);
        Item item = stack.getItem();
        if (item instanceof PartToolItem && (partToolItem = (PartToolItem)item).isCorrectTool(stack, state, partToolItem, stats = ((PartToolItem)stack.getItem()).getSumStats(player, level, stack)) && blockPosOptional.isPresent()) {
            BlockPos pos = (BlockPos)blockPosOptional.get();
            float[] speed = new float[]{stats.getStats().get(ToolStats.MIN_STAT).floatValue()};
            PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> {
                speed[0] = speed[0] + trait.modifyMiningSpeed(player, level, stack, (int)integer, stats, state, pos);
            });
            if (partToolItem.getToolType() == ToolType.HAMMER) {
                speed[0] = ModifyBreakSpeedEvent.getHammerMineSpeed(player, stack, pos, direction, speed[0]);
            }
            event.setNewSpeed(speed[0] * defaultSpeed);
        }
    }

    private static float getHammerMineSpeed(Player player, ItemStack stack, BlockPos pos, Direction direction, float defaultSpeed) {
        int x = 0;
        int y = 0;
        int z = 0;
        float hard = 0.0f;
        int count = 0;
        switch (direction) {
            case UP: 
            case DOWN: {
                x = 1;
                z = 1;
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = 1;
                y = 1;
                break;
            }
            case EAST: 
            case WEST: {
                y = 1;
                z = 1;
            }
        }
        for (int i = -x; i <= x; ++i) {
            for (int j = -y; j <= y; ++j) {
                for (int k = -z; k <= z; ++k) {
                    if (!((PartToolItem)stack.getItem()).isCorrectTool(stack, player.level().getBlockState(pos.offset(i, j, k)), (PartToolItem)stack.getItem(), ((PartToolItem)stack.getItem()).getSumStats(player, player.level(), stack))) continue;
                    hard += player.level().getBlockState(pos.offset(i, j, k)).getDestroySpeed((BlockGetter)player.level(), pos.offset(i, j, k));
                    ++count;
                }
            }
        }
        float centerHard = player.level().getBlockState(pos).getDestroySpeed((BlockGetter)player.level(), pos);
        float avgHard = hard / (float)count;
        float speed = defaultSpeed * (centerHard / avgHard) / (float)count;
        return speed;
    }
}

