/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.magic.mana.ManaData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class OverchargedTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        double maxMana;
        double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.MANA);
        if (currentMana >= (maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.MANA))) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.25f;
            Float elmAtk = stats.getStats().get(ToolStats.ELM_ATK_STAT);
            modified.put(ToolStats.ELM_ATK_STAT, Float.valueOf(elmAtk.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifyStatsConditional1(player, level, stack, traitLevel, stats);
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        double maxMana;
        double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.MANA);
        if (currentMana >= (maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.MANA)) / 2.0) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.35f;
            Float pwr = stats.getStats().get(ToolStats.PWR_STAT);
            Float chg = stats.getStats().get(ToolStats.CHG_STAT);
            modified.put(ToolStats.PWR_STAT, Float.valueOf(pwr.floatValue() * mul));
            modified.put(ToolStats.CHG_STAT, Float.valueOf(chg.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifySpellCasterStatsConditional1(player, level, stack, traitLevel, stats);
    }

    @Override
    public float modifyMiningSpeed(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos) {
        double maxMana;
        double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.MANA);
        if (currentMana >= (maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.MANA))) {
            float mul = (float)traitLevel * 0.35f;
            Float min = stats.getStats().get(ToolStats.MIN_STAT);
            return min.floatValue() * mul;
        }
        return super.modifyMiningSpeed(player, level, stack, traitLevel, stats, blockState, pos);
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        super.tick(player, level, stack, traitLevel, stats, isHost);
        double currentMana = ManaData.getCurrentMana(player, ManaUtil.ManaType.MANA);
        double maxMana = ManaUtil.getMaxMana(player, ManaUtil.ManaType.MANA);
        int n = stack.getItem() instanceof SpellCasterItem ? 2 : 1;
        if (currentMana >= maxMana / (double)n) {
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.9f, 1.0f, 0.7f), new Vector3f(0.3f, 1.0f, 0.9f), 1.0f, 1, 0.0f), (Entity)player, 1);
        }
    }

    @Override
    public int getColor() {
        return 8454080;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.overcharged");
    }
}

