/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.MembraneParticleEffect;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.particle.particle_option.SquareFieldParticleEffect;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import org.joml.Vector3f;

public class PhantomSlayerTrait
extends Trait {
    @Override
    public void traitAction(Player player, Level level, Entity target, Vec3 lookingPos, ItemStack stack, int traitLevel, ToolStats stats, InteractionHand hand, boolean isHost) {
        super.traitAction(player, level, target, lookingPos, stack, traitLevel, stats, hand, isHost);
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 forward = Vec3.directionFromRotation((Vec2)player.getRotationVector());
        if (lookingPos != null && player.position().distanceTo(lookingPos) < player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE) * Math.sqrt(traitLevel) && player.getAttackStrengthScale(0.5f) > 0.7f && target != null) {
            if (stack.getItem() instanceof SpellCasterItem) {
                player.addDeltaMovement(forward.scale(-1.2).add(0.0, 1.0, 0.0));
                if (traitLevel > 1 && !level.isClientSide) {
                    player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, traitLevel * 20, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, traitLevel * 5, 0));
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, traitLevel * 10, 0));
                }
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.PHANTOM_SLAYER_DASH.get(), SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
                EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 60);
                stack.hurtAndBreak(3, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            } else {
                boolean flag;
                Vec3 playerPos = new Vec3(player.getX(), player.getY(0.5), player.getZ());
                Vec3 distance = lookingPos.subtract(playerEyePos).normalize().multiply(2.0, 2.0, 2.0);
                Vec3 teleportPos = lookingPos.add(distance);
                BlockHitResult blockResult = level.clip(new ClipContext(lookingPos, teleportPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                boolean bl = flag = blockResult.getType() != HitResult.Type.BLOCK;
                if (flag) {
                    if (traitLevel > 1 && !level.isClientSide) {
                        player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, traitLevel * 10, 0));
                        player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, traitLevel * 5, 0));
                    }
                    ((PartToolItem)stack.getItem()).applyElementDamage(player, target, stack);
                    player.attack(target);
                    EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 20);
                    Vec3 delta = player.getDeltaMovement();
                    player.setPos(lookingPos.add(distance));
                    if (delta.length() < 0.5) {
                        delta.normalize().multiply(0.5, 0.5, 0.5);
                    }
                    player.setDeltaMovement(delta);
                    EffectUtil.lineEffect(level, new MembraneParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.0f), playerPos, teleportPos, 7, false);
                    stack.hurtAndBreak(3, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.PHANTOM_SLAYER_DASH.get(), SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
                    EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 60);
                }
            }
        }
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        Entity target;
        double mul;
        Vec3 forward;
        Vec3 maxReachPos;
        Vec3 playerEyePos;
        EntityHitResult result;
        super.tick(player, level, stack, traitLevel, stats, isHost);
        if (level.isClientSide && Minecraft.getInstance().isLocalPlayer(player.getUUID()) && player.tickCount % 10 == 0 && (result = EntityUtil.getEntityHitResult((Entity)player, playerEyePos = player.getEyePosition(), maxReachPos = playerEyePos.add((forward = Vec3.directionFromRotation((Vec2)player.getRotationVector())).multiply(mul = player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE) * Math.sqrt(traitLevel), mul, mul)), level)) != null && player.getAttackStrengthScale(0.5f) > 0.7f && (target = result.getEntity()) instanceof LivingEntity) {
            boolean flag;
            Vec3 distance;
            Vec3 teleportPos;
            Vec3 position = new Vec3(target.getX(), target.getY(0.5), target.getZ());
            BlockHitResult blockResult = level.clip(new ClipContext(position, teleportPos = position.add(distance = position.subtract(playerEyePos).normalize().multiply(2.0, 2.0, 2.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            boolean bl = flag = blockResult.getType() == HitResult.Type.MISS;
            if (flag) {
                level.addParticle((ParticleOptions)new SquareFieldParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), target.getX(), target.getY() + 0.1, target.getZ(), 0.0, 0.0, 0.0);
                EffectUtil.entityEffect(level, new UnstableSquareParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), target, 5);
            }
        }
    }

    @Override
    public void onDamageEntity(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, Entity target) {
        super.onDamageEntity(player, level, stack, traitLevel, stats, target);
        player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, traitLevel * 10, 0));
        player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, traitLevel * 5, 0));
        EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 20);
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.PHANTOM_BUFF.get(), SoundSource.PLAYERS, 0.5f, 0.7f + player.getRandom().nextFloat() * 0.6f);
    }

    @Override
    public void onBreakBlock(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.onBreakBlock(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        if (!level.isClientSide) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, traitLevel * 10, 0));
            player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, traitLevel * 5, 0));
        }
        EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 20);
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundInit.PHANTOM_BUFF.get(), SoundSource.PLAYERS, 0.5f, 0.7f + player.getRandom().nextFloat() * 0.6f);
    }

    @Override
    public int getColor() {
        return 0xFFFF80;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.phantom_slayer");
    }
}

