/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class ShatterforceTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        ToolStats aDefault = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
        float mul = (float)traitLevel * 0.35f * (float)stack.getDamageValue() / (float)stack.getMaxDamage();
        Float swp = stats.getStats().get(ToolStats.SWP_STAT);
        modified.put(ToolStats.SWP_STAT, Float.valueOf(swp.floatValue() * mul));
        return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        ToolStats aDefault = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
        float mul = (float)traitLevel * 0.35f * (float)stack.getDamageValue() / (float)stack.getMaxDamage();
        Float swp = stats.getStats().get(ToolStats.SWP_STAT);
        modified.put(ToolStats.SWP_STAT, Float.valueOf(swp.floatValue() * mul));
        return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
    }

    @Override
    public float modifyMiningSpeed(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos) {
        float mul = (float)traitLevel * 0.35f * (float)stack.getDamageValue() / (float)stack.getMaxDamage();
        Float min = stats.getStats().get(ToolStats.MIN_STAT);
        return min.floatValue() * mul;
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        super.tick(player, level, stack, traitLevel, stats, isHost);
        if (player.getRandom().nextFloat() < (float)stack.getDamageValue() / (float)stack.getMaxDamage()) {
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.9f, 0.6f, 1.0f), new Vector3f(0.9f, 0.6f, 1.0f), 1.0f, 1, 0.0f), (Entity)player, 1);
        }
    }

    @Override
    public int getColor() {
        return 0xF0A0FF;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.shatterforce");
    }
}

