/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.damage.DamageTypeInit;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.FrostParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class ShatterpiercerTrait
extends Trait {
    @Override
    public ToolStats modifySpellCasterStats1(ItemStack stack, int traitLevel, ToolStats stats) {
        if (stats.getElement() == Element.GLACE) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.1f;
            Float elmpwr = stats.getStats().get(ToolStats.ELM_PWR_STAT);
            modified.put(ToolStats.ELM_PWR_STAT, Float.valueOf(elmpwr.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifySpellCasterStats1(stack, traitLevel, stats);
    }

    @Override
    public Set<BlockPos> addAdditionalBlockBreakFirst(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, Direction direction) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        posSet.add(pos);
        int i = 0;
        while ((double)i < (double)traitLevel / 2.0) {
            if (level.getBlockState(pos.relative(direction, -i - 1)).getBlock() == level.getBlockState(pos).getBlock()) {
                posSet.add(pos.relative(direction, -i - 1));
            }
            ++i;
        }
        return posSet;
    }

    @Override
    public void onBreakBlock(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.onBreakBlock(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        if (!isInitial) {
            for (int i = 0; i < 20; ++i) {
                Vec3 offset = new Vec3((double)player.getRandom().nextFloat(), (double)player.getRandom().nextFloat(), (double)player.getRandom().nextFloat()).add(Vec3.atLowerCornerOf((Vec3i)pos));
                float rotSpeed = player.getRandom().nextFloat() / 5.0f - 0.1f;
                level.addParticle((ParticleOptions)new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, rotSpeed), offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
                level.playSound(player, pos, SoundInit.FROST_BREAK.get(), SoundSource.PLAYERS, 0.1f, 0.7f + player.getRandom().nextFloat() * 0.6f);
            }
        }
    }

    @Override
    public void onDamageEntity(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, Entity target) {
        super.onDamageEntity(player, level, stack, traitLevel, stats, target);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (livingEntity.getPercentFrozen() > 0.8f) {
                Vec3 range = new Vec3(3.0, 3.0, 3.0);
                ResourceKey<DamageType> damageType = DamageTypeInit.GLACE_DAMAGE;
                DamageSource damageSource = stack.has(DataComponents.CUSTOM_NAME) ? player.damageSources().source(damageType, (Entity)player) : player.damageSources().source(damageType);
                List list = level.getEntities((Entity)player, new AABB(target.position().subtract(range), target.position().add(range)), entity -> entity instanceof LivingEntity);
                for (Entity entity2 : list) {
                    entity2.hurt(damageSource, stats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue() * (float)Math.sqrt((double)traitLevel - 0.5));
                    EffectUtil.entityEffect(level, new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, 0.01f), entity2, 60);
                }
                for (int i = 0; i < 60; ++i) {
                    float rotSpeed = player.getRandom().nextFloat() / 5.0f - 0.1f;
                    Vec3 offset = new Vec3(3.0 * ((double)player.getRandom().nextFloat() - 0.5), 3.0 * ((double)player.getRandom().nextFloat() - 0.5), 3.0 * ((double)player.getRandom().nextFloat() - 0.5));
                    Vec3 randomBody = livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0).add(offset);
                    level.addParticle((ParticleOptions)new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, rotSpeed), randomBody.x, randomBody.y, randomBody.z, offset.x / 10.0, offset.y / 10.0, offset.z / 10.0);
                }
                livingEntity.setTicksFrozen(0);
                Vec3 pos = target.position();
                level.playSound(player, pos.x, pos.y, pos.z, SoundInit.FROST_BREAK.get(), SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
            } else {
                target.setTicksFrozen(250 * traitLevel / (traitLevel + 1) + target.getTicksFrozen());
                float rotSpeed = player.getRandom().nextFloat() / 5.0f - 0.1f;
                EffectUtil.entityEffect(level, new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 2.0f, 1, rotSpeed), (Entity)livingEntity, 60);
            }
        }
    }

    @Override
    public int getColor() {
        return 8454112;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.shatterpiercer");
    }
}

