/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class SignalRushTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional3(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        if (player.getFoodData().getSaturationLevel() > 0.0f) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.3f;
            int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
            if (signal > 0) {
                mul *= (float)signal * 0.8f + 1.0f;
            }
            Float spd = stats.getStats().get(ToolStats.SPD_STAT);
            modified.put(ToolStats.SPD_STAT, Float.valueOf(spd.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifyStatsConditional3(player, level, stack, traitLevel, stats);
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional3(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        if (player.getFoodData().getSaturationLevel() > 0.0f) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.3f;
            int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
            if (signal > 0) {
                mul *= (float)signal * 0.8f + 1.0f;
            }
            Float spd = stats.getStats().get(ToolStats.SPD_STAT);
            modified.put(ToolStats.SPD_STAT, Float.valueOf(spd.floatValue() * mul));
            Float min = stats.getStats().get(ToolStats.MIN_STAT);
            modified.put(ToolStats.MIN_STAT, Float.valueOf(min.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifySpellCasterStatsConditional3(player, level, stack, traitLevel, stats);
    }

    @Override
    public float modifyMiningSpeed(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos) {
        if (player.getFoodData().getSaturationLevel() > 0.0f) {
            float mul = (float)traitLevel * 0.4f;
            int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
            if (signal > 0) {
                mul *= (float)signal * 0.8f + 1.0f;
            }
            Float min = stats.getStats().get(ToolStats.MIN_STAT);
            return min.floatValue() * mul;
        }
        return super.modifyMiningSpeed(player, level, stack, traitLevel, stats, blockState, pos);
    }

    @Override
    public void onAttackEntity(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, Entity target) {
        super.onAttackEntity(player, level, stack, traitLevel, stats, target);
        int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
        if (signal == 0) {
            player.getFoodData().addExhaustion(1.0f);
        }
    }

    @Override
    public void onCastSpell(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        super.onCastSpell(player, level, stack, traitLevel, stats);
        int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
        if (signal == 0) {
            player.getFoodData().addExhaustion(1.0f);
        }
    }

    @Override
    public void onBreakBlock(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.onBreakBlock(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
        if (signal == 0 && isInitial) {
            player.getFoodData().addExhaustion(0.5f);
        }
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        super.tick(player, level, stack, traitLevel, stats, isHost);
        if (player.getFoodData().getSaturationLevel() > 0.0f) {
            int signal = Math.max(level.getBestNeighborSignal(player.getOnPos()), level.getSignal(player.getOnPos(), Direction.UP));
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, (float)signal / 20.0f, (float)signal / 20.0f), 1.0f, 1, 0.0f), (Entity)player, 1);
        }
    }

    @Override
    public int getColor() {
        return 0xC00000;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.signal_rush");
    }
}

