/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.stln.magitech.MagitechRegistries;
import net.stln.magitech.loot.LootFunctionInit;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.magic.spell.SpellLike;
import net.stln.magitech.util.ComponentHelper;
import org.jetbrains.annotations.NotNull;

public class RandomThreadPageFunction
extends LootItemConditionalFunction {
    public static final MapCodec<RandomThreadPageFunction> CODEC = RecordCodecBuilder.mapCodec(p_340803_ -> RandomThreadPageFunction.commonFields((RecordCodecBuilder.Instance)p_340803_).and((App)RegistryFixedCodec.create(MagitechRegistries.Keys.SPELL).listOf().fieldOf("spells").forGetter(RandomThreadPageFunction::getSpells)).apply((Applicative)p_340803_, RandomThreadPageFunction::new));
    protected final ArrayList<Holder<Spell>> spells;

    public RandomThreadPageFunction(List<LootItemCondition> lootItemConditions) {
        this(lootItemConditions, RandomThreadPageFunction.getAllSpells());
    }

    protected RandomThreadPageFunction(List<LootItemCondition> conditions, List<Holder<Spell>> spells) {
        super(conditions);
        this.spells = spells.isEmpty() ? new ArrayList<Holder<Spell>>(RandomThreadPageFunction.getAllSpells()) : new ArrayList<Holder<Spell>>(spells);
    }

    @NotNull
    private static List<Holder<Spell>> getAllSpells() {
        return MagitechRegistries.SPELL.holders().map(holder -> holder).toList();
    }

    public static LootItemFunction.Builder builder() {
        return RandomThreadPageFunction.simpleBuilder(RandomThreadPageFunction::new);
    }

    public List<Holder<Spell>> getSpells() {
        return this.spells;
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        Collections.shuffle(this.spells);
        return this.spells.stream().findAny().map(holder -> {
            if (holder.isBound()) {
                ComponentHelper.setThreadPage((MutableDataComponentHolder)stack, (SpellLike)holder.value());
            }
            return stack;
        }).orElse(stack);
    }

    @NotNull
    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)LootFunctionInit.RANDOM_THREAD_PAGE.get();
    }
}

