/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.charge;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.stln.magitech.magic.charge.Charge;

public class ChargeData {
    private static Map<Player, Charge> chargeMapClient = new HashMap<Player, Charge>();
    private static Map<Player, Charge> chargeMapServer = new HashMap<Player, Charge>();

    public static Map<Player, Charge> getChargeMapClient() {
        return chargeMapClient;
    }

    public static Map<Player, Charge> getChargeMapServer() {
        return chargeMapServer;
    }

    public static Map<Player, Charge> getChargeMap(boolean isClient) {
        if (isClient) {
            return chargeMapClient;
        }
        return chargeMapServer;
    }

    public static void cleanUp(Player player) {
        chargeMapClient.remove(player);
        chargeMapServer.remove(player);
    }

    public static void setCurrentCharge(Player player, Charge charge) {
        if (player.level().isClientSide) {
            chargeMapClient.put(player, charge);
        } else {
            chargeMapServer.put(player, charge);
        }
    }

    public static void removeCharge(Player player) {
        if (player.level().isClientSide) {
            chargeMapClient.remove(player);
        } else {
            chargeMapServer.remove(player);
        }
    }

    public static Charge getCurrentCharge(Player player) {
        if (player.level().isClientSide) {
            return chargeMapClient.getOrDefault(player, null);
        }
        return chargeMapServer.getOrDefault(player, null);
    }
}

