/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.cooldown;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.world.entity.player.Player;
import net.stln.magitech.magic.cooldown.Cooldown;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.util.TableHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CooldownData {
    private static final Table<Player, Spell, Cooldown> cooldownMapClient = HashBasedTable.create();
    private static final Table<Player, Spell, Cooldown> cooldownMapServer = HashBasedTable.create();
    private static final Table<Player, Spell, Cooldown> prevCooldownMapClient = HashBasedTable.create();
    private static final Table<Player, Spell, Cooldown> prevCooldownMapServer = HashBasedTable.create();

    @NotNull
    public static Table<Player, Spell, Cooldown> getCooldownMapClient() {
        return cooldownMapClient;
    }

    @NotNull
    public static Table<Player, Spell, Cooldown> getCooldownMapServer() {
        return cooldownMapServer;
    }

    @NotNull
    public static Table<Player, Spell, Cooldown> getCooldownMap(boolean isClient) {
        return isClient ? cooldownMapClient : cooldownMapServer;
    }

    @NotNull
    public static Table<Player, Spell, Cooldown> getPrevCooldownMap(boolean isClient) {
        return isClient ? prevCooldownMapClient : prevCooldownMapServer;
    }

    public static void cleanUp(Player player) {
        TableHelper.removeByRow(cooldownMapClient, player);
        TableHelper.removeByRow(cooldownMapServer, player);
        TableHelper.removeByRow(prevCooldownMapClient, player);
        TableHelper.removeByRow(prevCooldownMapServer, player);
    }

    public static void addCurrentCooldown(@NotNull Player player, @NotNull Spell spell, @NotNull Cooldown cooldown) {
        if (player.level().isClientSide) {
            Cooldown cooldownOld = (Cooldown)cooldownMapClient.get((Object)player, (Object)spell);
            if (cooldownOld != null) {
                prevCooldownMapClient.put((Object)player, (Object)spell, (Object)cooldownOld);
            }
            cooldownMapClient.put((Object)player, (Object)spell, (Object)cooldown);
        } else {
            Cooldown cooldownOld = (Cooldown)cooldownMapServer.get((Object)player, (Object)spell);
            if (cooldownOld != null) {
                prevCooldownMapServer.put((Object)player, (Object)spell, (Object)cooldownOld);
            }
            cooldownMapServer.put((Object)player, (Object)spell, (Object)cooldown);
        }
    }

    public static void removeCooldown(@NotNull Player player, @NotNull Spell spell) {
        if (player.level().isClientSide) {
            Cooldown cooldownOld = (Cooldown)cooldownMapClient.get((Object)player, (Object)spell);
            if (cooldownOld != null) {
                prevCooldownMapClient.put((Object)player, (Object)spell, (Object)cooldownOld);
            }
            cooldownMapClient.remove((Object)player, (Object)spell);
        } else {
            Cooldown cooldownOld = (Cooldown)cooldownMapServer.get((Object)player, (Object)spell);
            if (cooldownOld != null) {
                prevCooldownMapServer.put((Object)player, (Object)spell, (Object)cooldownOld);
            }
            cooldownMapServer.remove((Object)player, (Object)spell);
        }
    }

    public static void removePrevCooldown(@NotNull Player player, @NotNull Spell spell) {
        if (player.level().isClientSide) {
            prevCooldownMapClient.remove((Object)player, (Object)spell);
        } else {
            prevCooldownMapServer.remove((Object)player, (Object)spell);
        }
    }

    @Nullable
    public static Cooldown getCurrentCooldown(@NotNull Player player, @NotNull Spell spell) {
        Table<Player, Spell, Cooldown> table = player.level().isClientSide ? cooldownMapClient : cooldownMapServer;
        return (Cooldown)table.get((Object)player, (Object)spell);
    }

    @Nullable
    public static Cooldown getPrevCooldown(@NotNull Player player, @NotNull Spell spell) {
        Table<Player, Spell, Cooldown> table = player.level().isClientSide ? prevCooldownMapClient : prevCooldownMapServer;
        return (Cooldown)table.get((Object)player, (Object)spell);
    }
}

