/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.mana;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.stln.magitech.entity.status.AttributeInit;
import net.stln.magitech.magic.mana.ManaData;
import net.stln.magitech.network.SyncManaPayload;

public class ManaUtil {
    public static void tick(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.level().isClientSide) {
                ManaUtil.regenAllMana(player);
            }
        }
    }

    private static void regenAllMana(Player player) {
        ManaUtil.regenTickMana(player, ManaType.MANA);
        ManaUtil.regenTickMana(player, ManaType.NOCTIS);
        ManaUtil.regenTickMana(player, ManaType.LUMINIS);
        ManaUtil.regenTickMana(player, ManaType.FLUXIA);
    }

    public static void regenMana(Player player, ManaType type) {
        double regenAmount = ManaUtil.getManaRegen(player, type);
        ManaUtil.setMana(player, type, Math.min(regenAmount + ManaData.getCurrentMana(player, type), ManaUtil.getMaxMana(player, type)));
    }

    public static void regenTickMana(Player player, ManaType type) {
        double regenAmount = ManaUtil.getManaRegen(player, type) / 20.0;
        if (type != ManaType.MANA && ManaData.getCurrentMana(player, ManaType.MANA) < ManaUtil.getMaxMana(player, ManaType.MANA) / 2.0) {
            regenAmount /= 2.0;
        }
        ManaUtil.setMana(player, type, Math.min(regenAmount + ManaData.getCurrentMana(player, type), ManaUtil.getMaxMana(player, type)));
    }

    public static boolean checkMana(Player player, Map<ManaType, Double> map) {
        boolean flag = true;
        if (map.getOrDefault((Object)ManaType.MANA, 0.0) > ManaData.getPrevMana(player, ManaType.MANA) && !player.isCreative()) {
            flag = false;
            player.displayClientMessage((Component)Component.translatable((String)"spell.magitech.hint.not_enough_mana").withColor(0xFF8080), true);
        }
        return flag;
    }

    public static float checkStrandDamageMul(Player player, Map<ManaType, Double> map, float spellDamage) {
        for (Map.Entry<ManaType, Double> entry : map.entrySet()) {
            ManaType type = entry.getKey();
            Double value = entry.getValue();
            if (!(value > ManaData.getPrevMana(player, type)) || type == ManaType.MANA || player.isCreative()) continue;
            spellDamage /= 2.0f;
            player.displayClientMessage((Component)Component.translatable((String)("spell.magitech.hint.not_enough_" + type.getName())).withColor(0xFF8080), true);
        }
        return spellDamage;
    }

    public static boolean useMana(Player player, Map<ManaType, Double> map) {
        boolean flag = true;
        if (map.getOrDefault((Object)ManaType.MANA, 0.0) > ManaData.getPrevMana(player, ManaType.MANA) && !player.isCreative()) {
            flag = false;
        }
        if (flag) {
            if (!player.isCreative()) {
                for (Map.Entry<ManaType, Double> entry : map.entrySet()) {
                    ManaType type = entry.getKey();
                    Double value = entry.getValue();
                    ManaUtil.setMana(player, type, ManaData.getCurrentMana(player, type) - value);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean useManaServerOnly(Player player, Map<ManaType, Double> map) {
        boolean flag = true;
        if (map.getOrDefault((Object)ManaType.MANA, 0.0) > ManaData.getPrevMana(player, ManaType.MANA) && !player.isCreative()) {
            flag = false;
        }
        if (flag) {
            if (!player.level().isClientSide && !player.isCreative()) {
                for (Map.Entry<ManaType, Double> entry : map.entrySet()) {
                    ManaType type = entry.getKey();
                    Double value = entry.getValue();
                    ManaUtil.setMana(player, type, ManaData.getCurrentMana(player, type) - value);
                }
            }
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"spell.magitech.hint.not_enough_mana").withColor(0xFF8080), true);
        return false;
    }

    public static boolean useManaClientOnly(Player player, Map<ManaType, Double> map) {
        boolean flag = true;
        if (map.getOrDefault((Object)ManaType.MANA, 0.0) > ManaData.getPrevMana(player, ManaType.MANA) && !player.isCreative()) {
            flag = false;
        }
        if (flag) {
            if (player.level().isClientSide && !player.isCreative()) {
                for (Map.Entry<ManaType, Double> entry : map.entrySet()) {
                    ManaType type = entry.getKey();
                    Double value = entry.getValue();
                    ManaUtil.setMana(player, type, ManaData.getCurrentMana(player, type) - value);
                }
            }
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"spell.magitech.hint.not_enough_mana").withColor(0xFF8080), true);
        return false;
    }

    public static void setMana(Player player, ManaType type, double value) {
        ManaData.setPrevMana(player, type, ManaData.getCurrentMana(player, type));
        ManaData.setCurrentMana(player, type, value);
        if (player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncManaPayload(value, type.id, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncManaPayload(value, type.id, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static double getManaRegen(Player player, ManaType type) {
        DeferredHolder<Attribute, Attribute> attributeHolder = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AttributeInit.MANA_REGEN;
            case 1 -> AttributeInit.NOCTIS_REGEN;
            case 2 -> AttributeInit.LUMINIS_REGEN;
            case 3 -> AttributeInit.FLUXIA_REGEN;
        };
        AttributeInstance attribute = player.getAttribute(attributeHolder);
        return attribute == null ? 0.0 : attribute.getValue();
    }

    public static double getMaxMana(Player player, ManaType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (player.getAttribute(AttributeInit.MAX_MANA) == null) {
                    yield 0.0;
                }
                yield player.getAttribute(AttributeInit.MAX_MANA).getValue();
            }
            case 1 -> {
                if (player.getAttribute(AttributeInit.MAX_NOCTIS) == null) {
                    yield 0.0;
                }
                yield player.getAttribute(AttributeInit.MAX_NOCTIS).getValue();
            }
            case 2 -> {
                if (player.getAttribute(AttributeInit.MAX_LUMINIS) == null) {
                    yield 0.0;
                }
                yield player.getAttribute(AttributeInit.MAX_LUMINIS).getValue();
            }
            case 3 -> player.getAttribute(AttributeInit.MAX_FLUXIA) == null ? 0.0 : player.getAttribute(AttributeInit.MAX_FLUXIA).getValue();
        };
    }

    public static ManaType getManaType(int id) {
        for (ManaType manatype : ManaType.values()) {
            if (manatype.id != id) continue;
            return manatype;
        }
        return null;
    }

    public static enum ManaType {
        MANA(0, "mana"),
        NOCTIS(1, "noctis"),
        LUMINIS(2, "luminis"),
        FLUXIA(3, "fluxia");

        final int id;
        final String name;

        private ManaType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

