/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.util.EntityUtil;

public class BeamSpell
extends Spell {
    protected double beamradius = 0.2;

    protected static void playShootAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.setAnimation((IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_beam"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        this.callSuperFinishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                Vec3 forward = Vec3.directionFromRotation((Vec2)user.getRotationVector());
                Vec3 hitPos = EntityUtil.raycastBeam((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                BlockHitResult blockHitResult = EntityUtil.raycastBeamBlockHit((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                Entity target = EntityUtil.raycastBeamEntity((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                Vec3 start = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5));
                this.addVisualEffect(level, user, start, hitPos);
                this.playBeamSound(level, user);
                if (!level.isClientSide) {
                    if (target != null) {
                        this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, target);
                        if (target instanceof LivingEntity) {
                            LivingEntity livingTarget = (LivingEntity)target;
                            this.applyEffectToLivingTarget(level, user, livingTarget);
                        }
                    }
                    List<Entity> entities = EntityUtil.getEntitiesInBox(level, (Entity)user, hitPos, new Vec3(1.0, 1.0, 1.0));
                    for (Entity entity : entities) {
                        if (!(entity instanceof ItemEntity)) continue;
                        this.applyEffectToItem(level, user, entity);
                    }
                }
                if (blockHitResult != null && blockHitResult.getType() == HitResult.Type.BLOCK) {
                    BlockPos targetBlock = blockHitResult.getBlockPos();
                    this.applyEffectToBlock(level, user, stack, targetBlock);
                }
                this.addCooldown(level, user, stack);
                if (level.isClientSide) {
                    BeamSpell.playShootAnimation(user);
                }
                this.addCooldown(level, user, stack);
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    protected void callSuperFinishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
    }

    protected void applyEffectToLivingTarget(Level level, Player user, LivingEntity target) {
    }

    protected void applyEffectToBlock(Level level, Player user, ItemStack stack, BlockPos target) {
    }

    protected void addVisualEffect(Level level, Player user, Vec3 start, Vec3 hitPos) {
    }

    protected void playBeamSound(Level level, Player user) {
    }

    @Override
    public boolean canHoldUsing() {
        return true;
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null && !playerAnimationData.isActive()) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)4, (Ease)Ease.INSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_charge_beam"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

