/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.ember;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.particle.particle_option.FlameParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.SpellShape;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;

public class Blazewend
extends Spell {
    public Blazewend() {
        this.baseDamage = 8.0f;
        this.baseEffectStrength = 1.0f;
    }

    @Override
    public Element getElement() {
        return Element.EMBER;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.DASH;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseCost() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 70.0);
        cost.put(ManaUtil.ManaType.FLUXIA, 10.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 100;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        super.use(level, user, hand, isHost);
        ItemStack stack = user.getItemInHand(hand);
        float strength = this.getDamage(user, this.getCost(level, user, stack), this.baseEffectStrength, this.getElement());
        int duration = 10;
        Vec3 front = Vec3.directionFromRotation((Vec2)user.getRotationVector());
        user.addDeltaMovement(front.scale((double)(strength * 2.0f)));
        for (int i = 0; i < duration; ++i) {
            int finalI = i;
            TickScheduler.schedule(i, () -> {
                Vec3 back = Vec3.directionFromRotation((Vec2)user.getRotationVector()).scale(-1.0);
                Vec3 bodyPos = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0);
                Vec3 offset = bodyPos.add(back.scale(1.0));
                Vec3 center = user.getEyePosition().add(back);
                Vec3 center2 = center.add(back.scale(2.0));
                List<Entity> nearbyEntities = EntityUtil.getEntitiesInBox(level, (Entity)user, user.position(), new Vec3(3.0, 3.0, 3.0));
                Vec3 newFront = Vec3.directionFromRotation((Vec2)user.getRotationVector());
                user.addDeltaMovement(newFront.scale((double)(strength / 3.0f)));
                level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.BLAZEWEND.get(), SoundSource.PLAYERS, 1.0f, 0.7f + user.getRandom().nextFloat() * 0.6f);
                for (int j = 0; j < 10; ++j) {
                    level.addParticle((ParticleOptions)new FlameParticleEffect(new Vector3f(1.0f), new Vector3f(1.0f), 5.0f, 1, 0.3f), offset.x + ((double)user.getRandom().nextFloat() - 0.5) / 4.0, offset.y + ((double)user.getRandom().nextFloat() - 0.5) / 4.0, offset.z + ((double)user.getRandom().nextFloat() - 0.5) / 4.0, back.x * 0.75 + ((double)user.getRandom().nextFloat() - 0.5) / 2.0, back.y * 0.75 + ((double)user.getRandom().nextFloat() - 0.5) / 2.0, back.z * 0.75 + ((double)user.getRandom().nextFloat() - 0.5) / 2.0);
                }
                for (Entity entity : nearbyEntities) {
                    EffectUtil.entityEffect(level, new FlameParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), entity, 30);
                    if (!(entity instanceof LivingEntity) || !entity.isAlive()) continue;
                    this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, entity);
                    entity.setRemainingFireTicks(Math.min(200, entity.getRemainingFireTicks() + 100));
                }
                if (finalI + 1 == duration) {
                    user.setDeltaMovement(user.getDeltaMovement().scale(0.3));
                }
                user.fallDistance = 0.0f;
            }, level.isClientSide);
        }
        this.addCooldown(level, user, stack);
    }

    @Override
    public boolean canHoldUsing() {
        return false;
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (Ease)Ease.OUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_blink"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

