/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.hollow;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.VoidGlowParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.SpellShape;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;

public class Tenebport
extends Spell {
    protected static void playShootAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.setAnimation((IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_shoot"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    @Override
    public Element getElement() {
        return Element.HOLLOW;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.UTILITY;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 80.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 10.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 6000;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        level.playSound(user, user.position().x, user.position().y, user.position().z, SoundInit.TENEBPORT_CHARGE.get(), SoundSource.PLAYERS, 1.0f, 0.7f + user.getRandom().nextFloat() * 0.6f);
        this.addCharge(user, 100, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                Vec3 userPos = user.position();
                Vec3 above = userPos.add(0.0, 10.0, 0.0);
                EffectUtil.lineEffect(level, new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), userPos, above, 4, false);
                level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.3f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), above.toVector3f(), 5.0f, 1, 1.0f), userPos.x, userPos.y - 0.5, userPos.z, 0.0, 0.0, 0.0);
                for (int i = 0; i < 20; ++i) {
                    level.addParticle((ParticleOptions)new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), userPos.x, userPos.y, userPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
                }
                level.playSound(user, userPos.x, userPos.y, userPos.z, SoundInit.TENEBPORT.get(), SoundSource.PLAYERS, 1.0f, 0.7f + user.getRandom().nextFloat() * 0.6f);
                TickScheduler.schedule(1, () -> {
                    Vec3 newPos = user.position();
                    Vec3 newAbove = newPos.add(0.0, 10.0, 0.0);
                    EffectUtil.lineEffect(level, new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), newPos, newAbove, 4, false);
                    level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.3f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), newAbove.toVector3f(), 5.0f, 1, 1.0f), newPos.x, newPos.y - 0.5, newPos.z, 0.0, 0.0, 0.0);
                    for (int i = 0; i < 20; ++i) {
                        level.addParticle((ParticleOptions)new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), newPos.x, newPos.y, newPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
                    }
                    level.playSound(user, newPos.x, newPos.y, newPos.z, SoundInit.TENEBPORT.get(), SoundSource.PLAYERS, 1.0f, 0.7f + user.getRandom().nextFloat() * 0.6f);
                    livingEntity.fallDistance = 0.0f;
                }, level.isClientSide);
                if (level.isClientSide) {
                    Tenebport.playShootAnimation(user);
                }
                if (!level.isClientSide) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    DimensionTransition respawnPos = serverPlayer.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING);
                    serverPlayer.changeDimension(respawnPos);
                }
                this.addCooldown(level, user, stack);
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    @Override
    public boolean canHoldUsing() {
        return true;
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)3, (Ease)Ease.OUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_chant"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

