/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.mana;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.block.block_entity.ManaContainerBlockEntity;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.BeamSpell;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.ManaZapParticleEffect;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.SpellShape;
import org.joml.Vector3f;

public class Enercrux
extends BeamSpell {
    public Enercrux() {
        this.baseDamage = 5.0f;
        this.baseMaxRange = 8.0;
        this.beamradius = 0.3;
    }

    @Override
    public Element getElement() {
        return Element.NONE;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.INFUSE;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 30.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 30;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 5, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
    }

    @Override
    protected void applyEffectToLivingTarget(Level level, Player user, LivingEntity target) {
        super.applyEffectToLivingTarget(level, user, target);
    }

    @Override
    protected void applyEffectToBlock(Level level, Player user, ItemStack stack, BlockPos target) {
        super.applyEffectToBlock(level, user, stack, target);
        BlockEntity blockEntity = level.getBlockEntity(target);
        if (blockEntity instanceof ManaContainerBlockEntity) {
            ManaContainerBlockEntity manaContainerBlockEntity = (ManaContainerBlockEntity)blockEntity;
            manaContainerBlockEntity.addMana((int)Math.min(this.getRequiredMana(level, user, stack).get((Object)ManaUtil.ManaType.MANA), this.getBaseRequiredMana().get((Object)ManaUtil.ManaType.MANA) * 0.75));
        }
    }

    @Override
    protected void playBeamSound(Level level, Player user) {
        level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.ENERCRUX.get(), SoundSource.PLAYERS, 1.0f, 0.75f + user.getRandom().nextFloat() * 0.5f);
    }

    @Override
    protected void addVisualEffect(Level level, Player user, Vec3 start, Vec3 hitPos) {
        EffectUtil.lineEffect(level, new UnstableSquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, user.getRandom().nextInt(2, 5), 0.0f), start, hitPos, 2, false);
        level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), hitPos.toVector3f(), 0.4f, user.getRandom().nextInt(2, 5), 10.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new UnstableSquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, user.getRandom().nextInt(2, 5), 0.0f), hitPos.x + ((double)user.getRandom().nextFloat() - 0.5) / 3.0, hitPos.y + ((double)user.getRandom().nextFloat() - 0.5) / 3.0, hitPos.z + ((double)user.getRandom().nextFloat() - 0.5) / 3.0, (double)Mth.nextFloat((RandomSource)user.getRandom(), (float)-0.2f, (float)0.2f), (double)Mth.nextFloat((RandomSource)user.getRandom(), (float)-0.2f, (float)0.2f), (double)Mth.nextFloat((RandomSource)user.getRandom(), (float)-0.2f, (float)0.2f));
        }
        level.addParticle((ParticleOptions)new ManaZapParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f((float)hitPos.x, (float)hitPos.y, (float)hitPos.z), 1.0f, user.getRandom().nextInt(2, 5), 0.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
    }
}

