/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.stln.magitech.item.tool.ToolPart;
import net.stln.magitech.item.tool.ToolType;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.item.tool.model.ModelRegistrar;
import net.stln.magitech.item.tool.partitem.PartItem;
import net.stln.magitech.item.tool.register.ToolMaterialRegister;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.util.ComponentHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public class MagitechItemRendererMixin {
    @Final
    @Shadow
    private Minecraft minecraft;

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderItem(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel p_model, CallbackInfo ci) {
        ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
        ModelManager modelManager = this.minecraft.getModelManager();
        Item item = itemStack.getItem();
        if (item instanceof PartToolItem) {
            PartToolItem partToolItem = (PartToolItem)item;
            ToolType toolType = partToolItem.getToolType();
            List<ToolMaterial> partMaterials = ComponentHelper.getPartMaterials((DataComponentHolder)itemStack);
            for (int i = 0; i < partMaterials.size(); ++i) {
                ToolMaterial partMaterial = partMaterials.get(i);
                ToolPart toolPart = ToolMaterialRegister.getToolPartFromIndex(toolType, i);
                if (toolPart == null) continue;
                itemRenderer.render(new ItemStack((ItemLike)Items.IRON_INGOT), displayContext, leftHand, poseStack, bufferSource, combinedLight, combinedOverlay, modelManager.getModel(ModelResourceLocation.standalone((ResourceLocation)ModelRegistrar.getPartModelId(partMaterial, toolType.getId(), toolPart.get()))));
            }
        }
        if ((item = itemStack.getItem()) instanceof PartItem) {
            PartItem partItem = (PartItem)item;
            ComponentHelper.getMaterial((DataComponentHolder)itemStack).ifPresent(toolMaterial -> itemRenderer.render(new ItemStack((ItemLike)Items.IRON_INGOT), displayContext, leftHand, poseStack, bufferSource, combinedLight, combinedOverlay, modelManager.getModel(ModelResourceLocation.standalone((ResourceLocation)ModelRegistrar.getPartItemModelId(toolMaterial, partItem.getPart().get())))));
        }
    }
}

