/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.network;

import java.util.Objects;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.item.armor.AetherLifterItem;
import net.stln.magitech.network.DoubleJumpPayload;

public class DoubleJumpPayLoadHandler {
    public static void handleDataOnMainS2C(DoubleJumpPayload payload, IPayloadContext context) {
        Player player = null;
        Level level = context.player().level();
        for (Player search : level.players()) {
            if (!Objects.equals(search.getUUID(), payload.uuid())) continue;
            player = search;
            break;
        }
        if (player == null) {
            return;
        }
        ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
        if (boots.getItem() == ItemInit.AETHER_LIFTER.get()) {
            AetherLifterItem.doubleJump(player, payload.jumpCount(), boots);
        }
    }

    public static void handleDataOnMainC2S(DoubleJumpPayload payload, IPayloadContext context) {
        Player player = context.player().level().getPlayerByUUID(payload.uuid());
        if (player == null) {
            return;
        }
        ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
        if (boots.getItem() == ItemInit.AETHER_LIFTER.get()) {
            AetherLifterItem.doubleJump(player, payload.jumpCount(), boots);
        }
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            if (player.getUUID() == serverPlayer.getUUID()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

