/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.network;

import java.util.Objects;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.item.LeftClickOverrideItem;
import net.stln.magitech.network.LeftClickPayload;

public class LeftClickPayLoadHandler {
    public static void handleDataOnMainS2C(LeftClickPayload payload, IPayloadContext context) {
        Player player = null;
        Level level = context.player().level();
        for (Player search : level.players()) {
            if (!Objects.equals(search.getUUID(), payload.uuid())) continue;
            player = search;
            break;
        }
        if (player == null) {
            return;
        }
        Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (item instanceof LeftClickOverrideItem) {
            LeftClickOverrideItem clickOverrideItem = (LeftClickOverrideItem)item;
            if (payload.clickCount() != 0) {
                clickOverrideItem.onLeftClick(player, InteractionHand.MAIN_HAND, player.level());
            }
        }
    }

    public static void handleDataOnMainC2S(LeftClickPayload payload, IPayloadContext context) {
        Player player = context.player().level().getPlayerByUUID(payload.uuid());
        Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (item instanceof LeftClickOverrideItem) {
            LeftClickOverrideItem clickOverrideItem = (LeftClickOverrideItem)item;
            if (payload.clickCount() != 0) {
                clickOverrideItem.onLeftClick(player, InteractionHand.MAIN_HAND, player.level());
            }
        }
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            if (player.getUUID() == serverPlayer.getUUID()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

