/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.network;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.item.component.SpellComponent;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.network.ReleaseUsingSpellPayload;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.CuriosHelper;
import org.jetbrains.annotations.NotNull;

public class ReleaseUsingSpellPayLoadHandler {
    public static void handleDataOnMainS2C(ReleaseUsingSpellPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        Player player = level.players().stream().filter(search -> Objects.equals(search.getUUID(), payload.uuid())).findFirst().orElse(null);
        if (player == null) {
            return;
        }
        ReleaseUsingSpellPayLoadHandler.getSpell(player).ifPresent(spell -> spell.finishUsing(payload.stack(), player.level(), (LivingEntity)player, payload.chargeTime(), false));
    }

    public static void handleDataOnMainC2S(ReleaseUsingSpellPayload payload, IPayloadContext context) {
        Player player = context.player().level().getPlayerByUUID(payload.uuid());
        if (player == null) {
            return;
        }
        ReleaseUsingSpellPayLoadHandler.getSpell(player).ifPresent(spell -> spell.finishUsing(payload.stack(), player.level(), (LivingEntity)player, payload.chargeTime(), false));
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            if (player.getUUID() == serverPlayer.getUUID()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static Optional<Spell> getSpell(@NotNull Player player) {
        return CuriosHelper.getThreadBoundStack((LivingEntity)player).map(stack -> {
            SpellComponent spellComponent = ComponentHelper.getSpells((DataComponentHolder)stack);
            return spellComponent.spells().get(spellComponent.selected());
        });
    }
}

