/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.particle.GlowingParticle;
import net.stln.magitech.particle.particle_option.ZapParticleEffect;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ZapParticle
extends GlowingParticle {
    private final SpriteSet spriteProvider;
    private final Vector3f startColor;
    private final Vector3f endColor;
    private final Vector3f endPos;
    private final List<Vec3> segmentList = new ArrayList<Vec3>();

    public ZapParticle(ClientLevel clientWorld, double x, double y, double z, double vx, double vy, double vz, ZapParticleEffect parameters, SpriteSet spriteProvider) {
        super(clientWorld, x, y, z, vx, vy, vz);
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.lifetime = 2 + clientWorld.random.nextInt(0, 3);
        this.alpha = 1.0f;
        this.scale = parameters.getScale();
        this.gravity = 0.0f;
        this.friction = 1.0f;
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
        this.startColor = parameters.getFromColor();
        this.endColor = parameters.getToColor();
        this.endPos = parameters.getToPos();
        this.twinkle = parameters.getTwinkle();
        this.rotSpeed = parameters.getRotSpeed();
    }

    @Override
    public AABB getRenderBoundingBox(float partialTicks) {
        return new AABB(this.getPos(), new Vec3(this.endPos));
    }

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float tickDelta) {
        this.updateColor(tickDelta);
        if ((float)this.age >= (float)this.lifetime * 0.8f) {
            this.alpha = (float)(this.lifetime - this.age) / ((float)this.lifetime * 0.2f) * 0.6f + 0.2f;
        }
        if (this.twinkle > 1) {
            float multiplier = Math.max((float)this.age % (float)this.twinkle / (float)(this.twinkle - 1), 0.1f);
            this.rCol *= multiplier;
            this.gCol *= multiplier;
            this.bCol *= multiplier;
        }
        for (int i = 0; i < this.segmentList.size() - 1; ++i) {
            Vec3 nextFrom = this.segmentList.get(i);
            Vec3 nextTo = this.segmentList.get(i + 1);
            this.drawBeam(vertexConsumer, camera, nextFrom, nextTo, 0.2f, 1, 1, 1, 1);
        }
    }

    public void drawBeam(VertexConsumer vc, Camera camera, Vec3 start, Vec3 end, float width, int r, int g, int b, int a) {
        Vec3 cameraPos = camera.getPosition();
        Vec3 from = start.subtract(cameraPos);
        Vec3 to = end.subtract(cameraPos);
        Vector3f dir = to.subtract(from).normalize().toVector3f();
        Vector3f view = start.subtract(camera.getPosition()).toVector3f();
        Vec3 right = new Vec3((double)dir.x, (double)dir.y, (double)dir.z).cross(new Vec3((double)view.x, (double)view.y, (double)view.z)).normalize().scale((double)((float)((double)width / 2.0)));
        Vector3f v1 = from.add(right).toVector3f();
        Vector3f v2 = from.subtract(right).toVector3f();
        Vector3f v3 = to.subtract(right).toVector3f();
        Vector3f v4 = to.add(right).toVector3f();
        int light = 240;
        float f = this.getQuadSize(0.0f);
        float f1 = this.getU0();
        float f2 = this.getU1();
        float f3 = this.getV0();
        float f4 = this.getV1();
        int i = this.getLightColor(0.0f);
        this.renderVertex(vc, v1.x, v1.y, v1.z, 1.0f, -1.0f, f, f2, f4, i);
        this.renderVertex(vc, v2.x, v2.y, v2.z, 1.0f, 1.0f, f, f2, f3, i);
        this.renderVertex(vc, v3.x, v3.y, v3.z, -1.0f, 1.0f, f, f1, f3, i);
        this.renderVertex(vc, v4.x, v4.y, v4.z, -1.0f, -1.0f, f, f1, f4, i);
    }

    private void renderVertex(VertexConsumer buffer, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f).mul(quadSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
    }

    @NotNull
    public SingleQuadParticle.FacingCameraMode getFacingCameraMode() {
        return SingleQuadParticle.FacingCameraMode.LOOKAT_Y;
    }

    private void updateColor(float tickDelta) {
        float f = ((float)this.age + tickDelta) / ((float)this.lifetime + 1.0f);
        Vector3f vector3f = new Vector3f((Vector3fc)this.startColor).lerp((Vector3fc)this.endColor, f);
        this.rCol = vector3f.x();
        this.gCol = vector3f.y();
        this.bCol = vector3f.z();
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(this.xd, this.yd, this.zd);
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
        }
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
        this.segmentList.clear();
        Vec3 toPos = new Vec3(this.endPos);
        double distance = this.getPos().distanceTo(toPos);
        int segment = (int)Math.max(distance / Math.sqrt(distance), 3.0);
        this.segmentList.add(this.getPos());
        for (int i = 0; i < segment; ++i) {
            Vec3 nextTo = this.getPos().scale((double)(segment - (i + 1)) / (double)segment);
            nextTo = nextTo.add(toPos.scale((double)(i + 1) / (double)segment));
            if (i + 1 < segment) {
                nextTo = nextTo.add(((double)this.random.nextFloat() - 0.5) / 6.0 * distance, ((double)this.random.nextFloat() - 0.5) / 6.0 * distance, ((double)this.random.nextFloat() - 0.5) / 6.0 * distance);
            }
            this.segmentList.add(nextTo);
        }
        this.rotate();
        this.setSpriteFromAge(this.spriteProvider);
    }

    @Override
    protected int getLightColor(float tint) {
        return 240;
    }

    @Environment(value=EnvType.CLIENT)
    public record Provider(SpriteSet spriteProvider) implements ParticleProvider<ZapParticleEffect>
    {
        @NotNull
        public Particle createParticle(@NotNull ZapParticleEffect parameters, @NotNull ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
            return new ZapParticle(world, x, y, z, xd, yd, zd, parameters, this.spriteProvider);
        }
    }
}

