/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.input.GroupedMultiStackRecipeInput;
import org.jetbrains.annotations.NotNull;

public class AthanorPillarInfusionRecipe
implements Recipe<GroupedMultiStackRecipeInput> {
    protected final List<List<Ingredient>> ingredients;
    protected final ItemStack result;
    protected final String group;
    protected final ItemStack base;
    protected final int mana;

    public AthanorPillarInfusionRecipe(String group, ItemStack base, List<List<Ingredient>> ingredients, int mana, ItemStack result) {
        this.base = base;
        this.mana = mana;
        this.ingredients = ingredients;
        this.group = group;
        this.result = result;
    }

    public boolean matches(GroupedMultiStackRecipeInput input, @NotNull Level level) {
        if (input.outerSize() != this.ingredients.size()) {
            return false;
        }
        for (int i = 0; i < input.outerSize(); ++i) {
            List<ItemStack> group = input.stacks().get(i);
            if (i >= this.ingredients.size() || group.size() != this.ingredients.get(i).size() && !this.ingredients.get(i).isEmpty()) {
                return false;
            }
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.ingredientCount());
            for (ItemStack item : group) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            ArrayList<Ingredient> nonEmptyIngredients = new ArrayList<Ingredient>();
            for (Ingredient item : this.ingredients.get(i)) {
                if (item.isEmpty() || item.getItems()[0].is(Items.AIR)) continue;
                nonEmptyIngredients.add(item);
            }
            if (RecipeMatcher.findMatches(nonEmptyItems, nonEmptyIngredients) != null || nonEmptyItems.isEmpty() && nonEmptyIngredients.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull GroupedMultiStackRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList flatList = NonNullList.create();
        for (List<Ingredient> group : this.ingredients) {
            flatList.addAll(group);
        }
        return flatList;
    }

    public NonNullList<Ingredient> getInnerIngredients(int index) {
        return NonNullList.copyOf((Collection)this.ingredients.get(index));
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeType<?> getType() {
        return RecipeInit.ATHANOR_PILLAR_INFUSION_TYPE.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeInit.ATHANOR_PILLAR_INFUSION_SERIALIZER.get();
    }

    public ItemStack getBase() {
        return this.base;
    }

    public int getMana() {
        return this.mana;
    }

    public static class Serializer<T extends AthanorPillarInfusionRecipe>
    implements RecipeSerializer<T> {
        final Factory<T> factory;
        private final MapCodec<T> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

        protected Serializer(Factory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.mapCodec(p_340781_ -> p_340781_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_300947_ -> p_300947_.group), (App)ItemStack.STRICT_CODEC.fieldOf("base").forGetter(p_300947_ -> p_300947_.base), (App)Ingredient.LIST_CODEC.listOf().fieldOf("ingredients").forGetter(p_300947_ -> p_300947_.ingredients), (App)Codec.INT.optionalFieldOf("mana", (Object)0).forGetter(p_300947_ -> p_300947_.mana), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_302316_ -> p_302316_.result)).apply((Applicative)p_340781_, factory::create));
            this.streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.base, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()).apply(ByteBufCodecs.list()), r -> r.ingredients, (StreamCodec)ByteBufCodecs.INT, r -> r.mana, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, factory::create);
        }

        @NotNull
        public MapCodec<T> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface Factory<T extends AthanorPillarInfusionRecipe> {
        public T create(String var1, ItemStack var2, List<List<Ingredient>> var3, int var4, ItemStack var5);
    }
}

