/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.stln.magitech.Magitech;
import net.stln.magitech.recipe.AthanorPillarInfusionRecipe;
import net.stln.magitech.recipe.PartCuttingRecipe;
import net.stln.magitech.recipe.SpellConversionRecipe;
import net.stln.magitech.recipe.ToolAssemblyRecipe;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import net.stln.magitech.recipe.ZardiusCrucibleRecipe;
import org.jetbrains.annotations.NotNull;

public class RecipeInit {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"magitech");
    public static final Supplier<AthanorPillarInfusionRecipe.Serializer<AthanorPillarInfusionRecipe>> ATHANOR_PILLAR_INFUSION_SERIALIZER = RecipeInit.registerSerializer("athanor_pillar_infusion", () -> new AthanorPillarInfusionRecipe.Serializer<AthanorPillarInfusionRecipe>(AthanorPillarInfusionRecipe::new));
    public static final Supplier<RecipeSerializer<PartCuttingRecipe>> PART_CUTTING_SERIALIZER = RecipeInit.registerSerializer("part_cutting", PartCuttingRecipe.CODEC, PartCuttingRecipe.STREAM_CODEC);
    public static final Supplier<RecipeSerializer<SpellConversionRecipe>> SPELL_CONVERSION_SERIALIZER = RecipeInit.registerSerializer("spell_conversion", SpellConversionRecipe.CODEC, SpellConversionRecipe.STREAM_CODEC);
    public static final Supplier<ToolAssemblyRecipe.Serializer<ToolAssemblyRecipe>> TOOL_ASSEMBLY_SERIALIZER = RecipeInit.registerSerializer("tool_assembly", () -> new ToolAssemblyRecipe.Serializer<ToolAssemblyRecipe>(ToolAssemblyRecipe::new));
    public static final Supplier<RecipeSerializer<ZardiusCrucibleRecipe>> ZARDIUS_CRUCIBLE_SERIALIZER = RecipeInit.registerSerializer("zardius_crucible", ZardiusCrucibleRecipe.CODEC, ZardiusCrucibleRecipe.STREAM_CODEC);
    public static final Supplier<ToolMaterialRecipe.Serializer<ToolMaterialRecipe>> TOOL_MATERIAL_SERIALIZER = RecipeInit.registerSerializer("tool_material", () -> new ToolMaterialRecipe.Serializer<ToolMaterialRecipe>(ToolMaterialRecipe::new));
    public static final DeferredRegister<RecipeType<?>> TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"magitech");
    public static final Supplier<RecipeType<AthanorPillarInfusionRecipe>> ATHANOR_PILLAR_INFUSION_TYPE = RecipeInit.registerType("athanor_pillar_infusion");
    public static final Supplier<RecipeType<PartCuttingRecipe>> PART_CUTTING_TYPE = RecipeInit.registerType("part_cutting");
    public static final Supplier<RecipeType<SpellConversionRecipe>> SPELL_CONVERSION_TYPE = RecipeInit.registerType("spell_conversion");
    public static final Supplier<RecipeType<ToolAssemblyRecipe>> TOOL_ASSEMBLY_TYPE = RecipeInit.registerType("tool_assembly");
    public static final Supplier<RecipeType<ToolMaterialRecipe>> TOOL_MATERIAL_TYPE = RecipeInit.registerType("tool_material");
    public static final Supplier<RecipeType<ZardiusCrucibleRecipe>> ZARDIUS_CRUCIBLE_TYPE = RecipeInit.registerType("zardius_crucible");

    @NotNull
    private static <T extends RecipeSerializer<?>> Supplier<T> registerSerializer(@NotNull String name, @NotNull Supplier<T> supplier) {
        return SERIALIZERS.register(name, supplier);
    }

    @NotNull
    private static <T extends Recipe<?>> Supplier<RecipeSerializer<T>> registerSerializer(@NotNull String name, final @NotNull MapCodec<T> codec, final @NotNull StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        return SERIALIZERS.register(name, () -> new RecipeSerializer<T>(){

            @NotNull
            public MapCodec<T> codec() {
                return codec;
            }

            @NotNull
            public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        });
    }

    @NotNull
    private static <T extends Recipe<?>> Supplier<RecipeType<T>> registerType(@NotNull String name) {
        return TYPES.register(name, RecipeType::simple);
    }

    public static void registerRecipes(IEventBus eventBus) {
        Magitech.LOGGER.info("Registering Recipes for magitech");
        SERIALIZERS.register(eventBus);
        TYPES.register(eventBus);
    }
}

