/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.PartMaterialComponent;
import net.stln.magitech.item.tool.ToolPart;
import net.stln.magitech.item.tool.ToolType;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.item.tool.partitem.PartItem;
import net.stln.magitech.item.tool.register.ToolMaterialRegister;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.input.MultiStackRecipeInput;
import net.stln.magitech.util.ComponentHelper;
import org.jetbrains.annotations.NotNull;

public class ToolAssemblyRecipe
implements Recipe<MultiStackRecipeInput> {
    protected final List<Ingredient> ingredients;
    protected final ItemStack result;
    protected final String group;

    public ToolAssemblyRecipe(String group, List<Ingredient> ingredients, ItemStack result) {
        this.ingredients = ingredients;
        this.group = group;
        this.result = result;
    }

    public boolean matches(@NotNull MultiStackRecipeInput input, @NotNull Level level) {
        if (!(this.result.getItem() instanceof PartToolItem)) {
            throw new IllegalArgumentException("the result item expected to be a PartToolItem");
        }
        ToolType type = ((PartToolItem)this.result.getItem()).getToolType();
        if (this.isCorrectTypesForTool(input, type).stream().allMatch(Objects::isNull)) {
            return false;
        }
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (!this.ingredients.stream().allMatch(Ingredient::isSimple)) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.ingredientCount());
            for (ItemStack item : input.stacks()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
        }
        return input.size() == 1 && this.ingredients.size() == 1 ? this.ingredients.getFirst().test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null);
    }

    @NotNull
    public ItemStack assemble(@NotNull MultiStackRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        if (!(this.result.getItem() instanceof PartToolItem)) {
            throw new IllegalArgumentException("the result item expected to be a PartToolItem");
        }
        ToolType type = ((PartToolItem)this.result.getItem()).getToolType();
        List<ToolMaterial> toolMaterials = this.isCorrectTypesForTool(input, type);
        if (!toolMaterials.isEmpty()) {
            ItemStack stack = this.result.copy();
            stack.set(ComponentInit.PART_MATERIAL_COMPONENT, (Object)new PartMaterialComponent(toolMaterials));
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private List<ToolMaterial> isCorrectTypesForTool(MultiStackRecipeInput input, ToolType type) {
        if (input.size() == type.getSize()) {
            int i;
            boolean flag = true;
            ArrayList<ToolMaterial> result = new ArrayList<ToolMaterial>(type.getSize());
            for (int i2 = 0; i2 < type.getSize(); ++i2) {
                result.add(null);
            }
            ArrayList<ToolPart> partList = new ArrayList<ToolPart>();
            for (i = 0; i < type.getSize(); ++i) {
                partList.add(ToolMaterialRegister.getToolPartFromIndex(type, i));
            }
            for (i = 0; i < input.size(); ++i) {
                Item item = input.getItem(i).getItem();
                if (!(item instanceof PartItem)) continue;
                PartItem partItem = (PartItem)item;
                if (!input.getItem(i).has(ComponentInit.MATERIAL_COMPONENT.get())) continue;
                boolean found = partList.contains((Object)partItem.getPart());
                int index = partList.indexOf((Object)partItem.getPart());
                if (found) {
                    ComponentHelper.getMaterial((DataComponentHolder)input.getItem(i)).ifPresent(material -> {
                        result.set(index, (ToolMaterial)material);
                        partList.set(index, null);
                    });
                }
                flag &= found;
            }
            if (flag && partList.stream().allMatch(Objects::isNull)) {
                return result;
            }
        }
        return new ArrayList<ToolMaterial>();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(this.ingredients);
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeType<?> getType() {
        return RecipeInit.TOOL_ASSEMBLY_TYPE.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeInit.TOOL_ASSEMBLY_SERIALIZER.get();
    }

    public static class Serializer<T extends ToolAssemblyRecipe>
    implements RecipeSerializer<T> {
        final Factory<T> factory;
        private final MapCodec<T> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

        protected Serializer(Factory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.mapCodec(p_340781_ -> p_340781_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_300947_ -> p_300947_.group), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").forGetter(p_300947_ -> p_300947_.ingredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_302316_ -> p_302316_.result)).apply((Applicative)p_340781_, factory::create));
            this.streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.ingredients, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, factory::create);
        }

        @NotNull
        public MapCodec<T> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface Factory<T extends ToolAssemblyRecipe> {
        public T create(String var1, List<Ingredient> var2, ItemStack var3);
    }
}

