/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.RecipeInit;
import org.jetbrains.annotations.NotNull;

public class ToolMaterialRecipe
extends SingleItemRecipe {
    protected final ToolMaterial toolMaterial;

    public ToolMaterialRecipe(String group, Ingredient ingredient, ToolMaterial toolMaterial) {
        super(RecipeInit.TOOL_MATERIAL_TYPE.get(), (RecipeSerializer)RecipeInit.TOOL_MATERIAL_SERIALIZER.get(), group, ingredient, ItemStack.EMPTY);
        this.toolMaterial = toolMaterial;
    }

    public ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    public boolean matches(SingleRecipeInput input, @NotNull Level level) {
        return this.ingredient.test(input.item());
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return BlockInit.ENGINEERING_WORKBENCH.toStack();
    }

    public static class Serializer<T extends ToolMaterialRecipe>
    implements RecipeSerializer<T> {
        final Factory<T> factory;
        private final MapCodec<T> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

        protected Serializer(Factory<T> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.mapCodec(p_340781_ -> p_340781_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_300947_ -> ((ToolMaterialRecipe)p_300947_).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(p_301068_ -> ((ToolMaterialRecipe)p_301068_).ingredient), (App)ToolMaterial.CODEC.fieldOf("result").forGetter(p_302316_ -> p_302316_.toolMaterial)).apply((Applicative)p_340781_, factory::create));
            this.streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, p_319737_ -> ((ToolMaterialRecipe)p_319737_).group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, p_319738_ -> ((ToolMaterialRecipe)p_319738_).ingredient, ToolMaterial.STREAM_CODEC, p_319736_ -> p_319736_.toolMaterial, factory::create);
        }

        @NotNull
        public MapCodec<T> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface Factory<T extends SingleItemRecipe> {
        public T create(String var1, Ingredient var2, ToolMaterial var3);
    }
}

