/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.input.CrucibleRecipeInput;
import org.jetbrains.annotations.NotNull;

public record ZardiusCrucibleRecipe(String group, List<Ingredient> ingredients, SizedFluidIngredient fluidIngredient, Optional<ItemStack> result, Optional<FluidStack> resultFluid) implements Recipe<CrucibleRecipeInput>
{
    public static final MapCodec<ZardiusCrucibleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ZardiusCrucibleRecipe::group), (App)Ingredient.CODEC_NONEMPTY.listOf(1, Integer.MAX_VALUE).fieldOf("ingredients").forGetter(ZardiusCrucibleRecipe::ingredients), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid_ingredient").forGetter(ZardiusCrucibleRecipe::fluidIngredient), (App)ItemStack.STRICT_CODEC.optionalFieldOf("result").forGetter(ZardiusCrucibleRecipe::result), (App)FluidStack.CODEC.optionalFieldOf("fluid_result").forGetter(ZardiusCrucibleRecipe::resultFluid)).apply((Applicative)instance, ZardiusCrucibleRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ZardiusCrucibleRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ZardiusCrucibleRecipe::group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), ZardiusCrucibleRecipe::ingredients, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, ZardiusCrucibleRecipe::fluidIngredient, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs::optional), ZardiusCrucibleRecipe::result, (StreamCodec)FluidStack.STREAM_CODEC.apply(ByteBufCodecs::optional), ZardiusCrucibleRecipe::resultFluid, ZardiusCrucibleRecipe::new);

    public boolean matches(@NotNull CrucibleRecipeInput input, @NotNull Level level) {
        List<ItemStack> inputItems = input.items().stream().filter(stack -> !stack.isEmpty() && stack.getItem() != Items.AIR).toList();
        int[] matchedSlots = RecipeMatcher.findMatches(inputItems, this.ingredients);
        if (matchedSlots != null) {
            return this.fluidIngredient.test(input.fluid());
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CrucibleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(this.ingredients.stream().filter(ing -> !ing.isEmpty()).toList());
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.orElse(ItemStack.EMPTY);
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return BlockInit.ZARDIUS_CRUCIBLE.toStack();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeInit.ZARDIUS_CRUCIBLE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return RecipeInit.ZARDIUS_CRUCIBLE_TYPE.get();
    }
}

