/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe.input;

import com.ibm.icu.impl.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public record GroupedMultiStackRecipeInput(List<List<ItemStack>> stacks) implements RecipeInput
{
    public ItemStack getItem(int index) {
        int count = 0;
        for (List<ItemStack> group : this.stacks) {
            for (ItemStack stack : group) {
                if (count == index) {
                    return stack;
                }
                ++count;
            }
        }
        throw new IndexOutOfBoundsException("Index out of bounds for GroupedMultiStackRecipeInput: " + index);
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (List<ItemStack> group : this.stacks) {
            for (ItemStack stack : group) {
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public ItemStack getItem(int index, int innerIndex) {
        try {
            return this.stacks.get(index).get(innerIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Index out of bounds for GroupedMultiStackRecipeInput: " + index + ", " + innerIndex);
        }
    }

    public int size() {
        int total = 0;
        for (List<ItemStack> group : this.stacks) {
            total += group.size();
        }
        return total;
    }

    public int outerSize() {
        return this.stacks.size();
    }

    public int innerSize(int index) {
        return this.stacks.get(index).size();
    }

    public boolean isEmpty() {
        for (List<ItemStack> group : this.stacks) {
            for (ItemStack stack : group) {
                if (stack.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public int ingredientCount() {
        int count = 0;
        for (List<ItemStack> group : this.stacks) {
            for (ItemStack stack : group) {
                if (stack.isEmpty()) continue;
                ++count;
            }
        }
        return count;
    }

    public StackedContents stackedContents() {
        StackedContents contents = new StackedContents();
        for (List<ItemStack> group : this.stacks) {
            for (ItemStack stack : group) {
                if (stack.isEmpty()) continue;
                contents.accountStack(stack, 1);
            }
        }
        return contents;
    }

    public Pair<Integer, Integer> to2DIndex(int flatIndex) {
        int count = 0;
        for (int i = 0; i < this.stacks.size(); ++i) {
            List<ItemStack> group = this.stacks.get(i);
            for (int j = 0; j < group.size(); ++j) {
                if (count == flatIndex) {
                    return Pair.of((Object)i, (Object)j);
                }
                ++count;
            }
        }
        throw new IndexOutOfBoundsException("Index out of bounds: " + flatIndex);
    }
}

