/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe.input;

import java.util.List;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.NotNull;

public record MultiStackRecipeInput(List<ItemStack> stacks) implements RecipeInput
{
    @NotNull
    public ItemStack getItem(int index) {
        return this.stacks.get(index);
    }

    public int size() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public int ingredientCount() {
        int i = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    public StackedContents stackedContents() {
        StackedContents stackedContents = new StackedContents();
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            stackedContents.accountStack(itemstack, 1);
        }
        return stackedContents;
    }
}

