/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BlockUtil {
    public static Set<BlockPos> getConnectedBlocks(Level level, BlockPos startPos, Block targetBlock, int limit) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty() && result.size() < limit + 1) {
            BlockPos current = (BlockPos)queue.poll();
            if (level.getBlockState(current).getBlock() == targetBlock) {
                result.add(current);
            }
            for (Direction direction : Direction.values()) {
                BlockPos neighbor;
                if (!BlockUtil.isInLimit(visited, limit) || visited.contains(neighbor = current.relative(direction)) || level.getBlockState(neighbor).getBlock() != targetBlock) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
            for (Direction direction : Direction.values()) {
                for (Direction direction2 : Direction.values()) {
                    BlockPos neighbor;
                    if (!BlockUtil.isInLimit(visited, limit) || direction2.getAxis() == direction.getAxis() || visited.contains(neighbor = current.relative(direction).relative(direction2)) || level.getBlockState(neighbor).getBlock() != targetBlock) continue;
                    visited.add(neighbor);
                    queue.add(neighbor);
                }
            }
            for (Direction direction : Direction.values()) {
                for (Direction direction2 : Direction.values()) {
                    for (Direction direction3 : Direction.values()) {
                        BlockPos neighbor;
                        if (!BlockUtil.isInLimit(visited, limit) || direction2.getAxis() == direction.getAxis() || direction3.getAxis() == direction.getAxis() || direction3.getAxis() == direction2.getAxis() || visited.contains(neighbor = current.relative(direction)) || level.getBlockState(neighbor).getBlock() != targetBlock) continue;
                        visited.add(neighbor);
                        queue.add(neighbor);
                    }
                }
            }
        }
        return result;
    }

    private static boolean isInLimit(Set<BlockPos> posSet, int limit) {
        return posSet.size() < limit;
    }
}

