/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientHelper {
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static Optional<Player> getOptionalPlayer() {
        return Optional.ofNullable(ClientHelper.getPlayer());
    }

    @Nullable
    public static Level getLevel() {
        Player player = ClientHelper.getPlayer();
        return player == null ? null : player.level();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static RecipeManager getRecipeManager() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        return clientLevel != null ? clientLevel.getRecipeManager() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static <I extends RecipeInput, R extends Recipe<I>> @NotNull List<@NotNull R> getAllRecipes(@NotNull Supplier<? extends RecipeType<R>> supplier) {
        RecipeManager recipeManager = ClientHelper.getRecipeManager();
        if (recipeManager == null) {
            return List.of();
        }
        return recipeManager.getAllRecipesFor(supplier.get()).stream().map(RecipeHolder::value).toList();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static RegistryAccess getRegistryAccess() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        return clientLevel != null ? clientLevel.registryAccess() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<ToolMaterial> getAllCraftableMaterials() {
        List<ToolMaterialRecipe> materialRecipes = ClientHelper.getAllRecipes(RecipeInit.TOOL_MATERIAL_TYPE);
        return materialRecipes.stream().map(ToolMaterialRecipe::getToolMaterial).toList();
    }
}

