/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.awt.Color;
import net.stln.magitech.util.MathHelper;

public class ColorHelper {
    public static int channelFromFloat(float value) {
        return MathHelper.floor(value * 255.0f);
    }

    public static int getTierColor(int tier) {
        if (tier <= 4) {
            double t = (double)tier / (double)Math.max(1, 4);
            double l = ColorHelper.interpolate(40.0, 55.0, t);
            Color c = ColorHelper.hslToRgb(0.0, 0.0, l);
            return ColorHelper.rgbToInt(c);
        }
        int tiersPerSegment = 5;
        int baseH = 70;
        int relativeTier = tier - 5;
        int segmentIndex = relativeTier / tiersPerSegment;
        int segmentOffset = relativeTier % tiersPerSegment;
        int rollCount = 0;
        int prevH = baseH % 360;
        for (int i = 1; i <= segmentIndex; ++i) {
            int currentH = (baseH + i * 110) % 360;
            if (currentH < prevH) {
                ++rollCount;
            }
            prevH = currentH;
        }
        int h1 = (baseH + segmentIndex * 110) % 360;
        int h2 = (h1 + 45) % 360;
        double l1 = Math.min(40 + rollCount * 10, 90);
        double l2 = Math.min(65 + rollCount * 10, 95);
        double t = (double)segmentOffset / (double)(tiersPerSegment - 1);
        double h = ColorHelper.interpolateHue(h1, h2, t);
        double s = ColorHelper.interpolate(30.0, 75.0, t);
        double l = ColorHelper.interpolate(l1, l2, t);
        Color c = ColorHelper.hslToRgb(h, s, l);
        return ColorHelper.rgbToInt(c);
    }

    private static double interpolate(double start, double end, double t) {
        return start + (end - start) * t;
    }

    private static double interpolateHue(double h1, double h2, double t) {
        double delta = (h2 - h1 + 540.0) % 360.0 - 180.0;
        return (h1 + delta * t + 360.0) % 360.0;
    }

    private static Color hslToRgb(double h, double s, double l) {
        double c = (1.0 - Math.abs(2.0 * (l /= 100.0) - 1.0)) * (s /= 100.0);
        double x = c * (1.0 - Math.abs(h / 60.0 % 2.0 - 1.0));
        double m = l - c / 2.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (0.0 <= h && h < 60.0) {
            r = c;
            g = x;
            b = 0.0;
        } else if (h < 120.0) {
            r = x;
            g = c;
            b = 0.0;
        } else if (h < 180.0) {
            r = 0.0;
            g = c;
            b = x;
        } else if (h < 240.0) {
            r = 0.0;
            g = x;
            b = c;
        } else if (h < 300.0) {
            r = x;
            g = 0.0;
            b = c;
        } else {
            r = c;
            g = 0.0;
            b = x;
        }
        int R = (int)Math.round((r + m) * 255.0);
        int G = (int)Math.round((g + m) * 255.0);
        int B = (int)Math.round((b + m) * 255.0);
        return new Color(ColorHelper.clamp(R), ColorHelper.clamp(G), ColorHelper.clamp(B));
    }

    private static int rgbToInt(Color c) {
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    private static int clamp(int val) {
        return Math.max(0, Math.min(255, val));
    }

    public static class Argb {
        public static int getAlpha(int argb) {
            return argb >>> 24;
        }

        public static int getRed(int argb) {
            return argb >> 16 & 0xFF;
        }

        public static int getGreen(int argb) {
            return argb >> 8 & 0xFF;
        }

        public static int getBlue(int argb) {
            return argb & 0xFF;
        }

        public static int getArgb(int alpha, int red, int green, int blue) {
            return alpha << 24 | red << 16 | green << 8 | blue;
        }

        public static int getArgb(int red, int green, int blue) {
            return Argb.getArgb(255, red, green, blue);
        }

        public static int mixColor(int first, int second) {
            return Argb.getArgb(Argb.getAlpha(first) * Argb.getAlpha(second) / 255, Argb.getRed(first) * Argb.getRed(second) / 255, Argb.getGreen(first) * Argb.getGreen(second) / 255, Argb.getBlue(first) * Argb.getBlue(second) / 255);
        }

        public static int lerp(float delta, int start, int end) {
            int i = MathHelper.lerp(delta, Argb.getAlpha(start), Argb.getAlpha(end));
            int j = MathHelper.lerp(delta, Argb.getRed(start), Argb.getRed(end));
            int k = MathHelper.lerp(delta, Argb.getGreen(start), Argb.getGreen(end));
            int l = MathHelper.lerp(delta, Argb.getBlue(start), Argb.getBlue(end));
            return Argb.getArgb(i, j, k, l);
        }

        public static int fullAlpha(int argb) {
            return argb | 0xFF000000;
        }

        public static int withAlpha(int alpha, int rgb) {
            return alpha << 24 | rgb & 0xFFFFFF;
        }

        public static int fromFloats(float a, float r, float g, float b) {
            return Argb.getArgb(ColorHelper.channelFromFloat(a), ColorHelper.channelFromFloat(r), ColorHelper.channelFromFloat(g), ColorHelper.channelFromFloat(b));
        }

        public static int averageArgb(int a, int b) {
            return Argb.getArgb((Argb.getAlpha(a) + Argb.getAlpha(b)) / 2, (Argb.getRed(a) + Argb.getRed(b)) / 2, (Argb.getGreen(a) + Argb.getGreen(b)) / 2, (Argb.getBlue(a) + Argb.getBlue(b)) / 2);
        }

        public static int mul(int color, int mulColor) {
            int alpha = Math.clamp((long)Argb.getAlpha(color) * (long)Argb.getAlpha(mulColor) / 255L, 0, 255);
            int red = Math.clamp((long)Argb.getRed(color) * (long)Argb.getRed(mulColor) / 255L, 0, 255);
            int green = Math.clamp((long)Argb.getGreen(color) * (long)Argb.getGreen(mulColor) / 255L, 0, 255);
            int blue = Math.clamp((long)Argb.getBlue(color) * (long)Argb.getBlue(mulColor) / 255L, 0, 255);
            return Argb.getArgb(alpha, red, green, blue);
        }
    }

    public static class Abgr {
        public static int getAlpha(int abgr) {
            return abgr >>> 24;
        }

        public static int getRed(int abgr) {
            return abgr & 0xFF;
        }

        public static int getGreen(int abgr) {
            return abgr >> 8 & 0xFF;
        }

        public static int getBlue(int abgr) {
            return abgr >> 16 & 0xFF;
        }

        public static int getBgr(int abgr) {
            return abgr & 0xFFFFFF;
        }

        public static int toOpaque(int abgr) {
            return abgr | 0xFF000000;
        }

        public static int getAbgr(int a, int b, int g, int r) {
            return a << 24 | b << 16 | g << 8 | r;
        }

        public static int withAlpha(int alpha, int bgr) {
            return alpha << 24 | bgr & 0xFFFFFF;
        }

        public static int toAbgr(int argb) {
            return argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
        }

        public static int mul(int color, int mulColor) {
            int alpha = Math.clamp((long)Abgr.getAlpha(color) * (long)Abgr.getAlpha(mulColor), 0, 255);
            int red = Math.clamp((long)Abgr.getRed(color) * (long)Abgr.getRed(mulColor), 0, 255);
            int green = Math.clamp((long)Abgr.getGreen(color) * (long)Abgr.getGreen(mulColor), 0, 255);
            int blue = Math.clamp((long)Abgr.getBlue(color) * (long)Abgr.getBlue(mulColor), 0, 255);
            return Abgr.getAbgr(alpha, blue, green, red);
        }
    }
}

