/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.stln.magitech.item.tool.ToolBeltItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosHelper {
    @NotNull
    private static Optional<ICuriosItemHandler> getOptionalCuriosInventory(@Nullable LivingEntity entity) {
        return entity == null ? Optional.empty() : CuriosApi.getCuriosInventory((LivingEntity)entity);
    }

    @NotNull
    private static Optional<ICurioStacksHandler> getThreadBoundSlot(@Nullable LivingEntity entity) {
        return CuriosHelper.getOptionalCuriosInventory(entity).map(ICuriosItemHandler::getCurios).flatMap(map -> Optional.ofNullable((ICurioStacksHandler)map.get("threadbound")));
    }

    @NotNull
    private static Optional<ICurioStacksHandler> getBeltSlot(@Nullable LivingEntity entity) {
        return CuriosHelper.getOptionalCuriosInventory(entity).map(ICuriosItemHandler::getCurios).flatMap(map -> Optional.ofNullable((ICurioStacksHandler)map.get("belt")));
    }

    @NotNull
    public static Optional<ItemStack> getThreadBoundStack(@Nullable LivingEntity entity) {
        if (!ModList.get().isLoaded("curios")) {
            return Optional.empty();
        }
        return CuriosHelper.getThreadBoundSlot(entity).map(ICurioStacksHandler::getStacks).map(iDynamicStackHandler -> iDynamicStackHandler.getStackInSlot(0)).filter(stack -> !stack.isEmpty());
    }

    @NotNull
    public static Optional<ItemStack> getToolBeltStack(@Nullable LivingEntity entity) {
        if (!ModList.get().isLoaded("curios")) {
            return Optional.empty();
        }
        return CuriosHelper.getBeltSlot(entity).map(ICurioStacksHandler::getStacks).map(stacks -> {
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (!(stacks.getStackInSlot(i).getItem() instanceof ToolBeltItem)) continue;
                return stacks.getStackInSlot(i);
            }
            return ItemStack.EMPTY;
        }).filter(stack -> !stack.isEmpty());
    }
}

