/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.stln.magitech.damage.ElementAffinity;
import net.stln.magitech.damage.ElementAffinityRegister;
import net.stln.magitech.data.DataMapTypeInit;
import net.stln.magitech.data.EntityElementData;
import net.stln.magitech.element.Element;
import org.jetbrains.annotations.NotNull;

public class DataMapHelper {
    @NotNull
    public static Optional<ElementAffinity> getElementAffinity(@NotNull Entity target, @NotNull Element element) {
        EntityElementData elementData = (EntityElementData)BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)target.getType()).getData(DataMapTypeInit.ENTITY_ELEMENT);
        if (elementData != null) {
            Element targetElement = elementData.element();
            return Optional.of(ElementAffinityRegister.getElementAffinity(element, targetElement));
        }
        return Optional.empty();
    }

    public static float getElementMultiplier(@NotNull Entity target, @NotNull Element element) {
        return DataMapHelper.getElementAffinity(target, element).map(ElementAffinity::getMultiplier).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

