/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.util.TickScheduler;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EffectUtil {
    public static void lineEffect(Level level, ParticleOptions particleOptions, Vec3 start, Vec3 end, int density, boolean alwaysVisible) {
        if (!level.isClientSide) {
            return;
        }
        int amount = (int)((double)density * start.distanceTo(end));
        for (int i = 0; i < amount; ++i) {
            double offset = (double)i / (double)(amount - 1);
            Vec3 currentPos = start.add(end.subtract(start).multiply(offset, offset, offset));
            EffectUtil.displayParticle(level, particleOptions, alwaysVisible, currentPos.x, currentPos.y, currentPos.z, 0.0, 0.0, 0.0);
        }
    }

    public static void entityEffect(Level level, ParticleOptions particleOptions, Entity entity, int amount) {
        EffectUtil.entityEffect(level, () -> particleOptions, () -> new Vec3(0.0, 0.0, 0.0), entity, amount);
    }

    public static void entityEffect(Level level, Supplier<ParticleOptions> particleOptions, Supplier<Vec3> vector, Entity entity, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 vec3 = vector.get();
            Vec3 randomBody = new Vec3(entity.getX() + (double)(entity.getBbWidth() + 0.5f) * ((double)entity.getRandom().nextFloat() - 0.5), entity.getY(0.5) + (double)(entity.getBbHeight() + 0.5f) * ((double)entity.getRandom().nextFloat() - 0.5), entity.getZ() + (double)(entity.getBbWidth() + 0.5f) * ((double)entity.getRandom().nextFloat() - 0.5));
            level.addParticle(particleOptions.get(), randomBody.x, randomBody.y, randomBody.z, vec3.x, vec3.y, vec3.z);
        }
    }

    public static void sweepEffect(Player player, Level world, ParticleOptions particleEffect, double randomizer, Vec3 center, double startDeg, double endDeg, int density, double radius, double slopeDeg, boolean alwaysVisible) {
        if (!world.isClientSide) {
            return;
        }
        float f = player.getRandom().nextFloat();
        float f2 = player.getMainArm() == HumanoidArm.LEFT ? 0.2f : 0.8f;
        if (f > f2) {
            startDeg *= -1.0;
            endDeg *= -1.0;
        }
        density = (int)((double)density * (radius * Math.abs((double)(endDeg - startDeg)) / 200.0));
        Vec3 lookVec = Vec3.directionFromRotation((Vec2)player.getRotationVector());
        double yawRad = Math.toRadians((float)player.getRotationVector().y);
        Vec3 rightVec = new Vec3(Math.cos((double)yawRad), 0.0, Math.sin((double)yawRad)).normalize();
        Vec3 upVec = lookVec.cross(rightVec).normalize();
        for (int i = 0; i < density; ++i) {
            double t = (double)i / (double)(density - 1);
            double angleDeg = startDeg + (endDeg - startDeg) * t;
            Vec3 axisVec = EffectUtil.rotateVector(upVec, lookVec, slopeDeg);
            Vec3 offset = EffectUtil.rotateVector(lookVec, axisVec, angleDeg);
            double x = center.x - offset.x * radius;
            double y = center.y - offset.y * radius;
            double z = center.z - offset.z * radius;
            double t1 = (double)(i + density / 10) / (double)(density - 1);
            double angleDeg1 = startDeg + (endDeg - startDeg) * t1;
            Vec3 axisVec1 = EffectUtil.rotateVector(upVec, lookVec, slopeDeg);
            Vec3 offset1 = EffectUtil.rotateVector(lookVec, axisVec1, angleDeg1);
            double x1 = center.x - offset1.x * radius;
            double y1 = center.y - offset1.y * radius;
            double z1 = center.z - offset1.z * radius;
            double xOffset = (x1 - x) / 10.0 + Mth.nextDouble((RandomSource)player.getRandom(), (double)-1.0, (double)1.0) * randomizer;
            double yOffset = (y1 - y) / 10.0 + Mth.nextDouble((RandomSource)player.getRandom(), (double)-1.0, (double)1.0) * randomizer;
            double zOffset = (z1 - z) / 10.0 + Mth.nextDouble((RandomSource)player.getRandom(), (double)-1.0, (double)1.0) * randomizer;
            int delay = (int)Math.floor((double)(t * 3.0));
            if (delay < 0) {
                EffectUtil.displayParticle(world, particleEffect, alwaysVisible, x, y, z, xOffset, yOffset, zOffset);
                continue;
            }
            TickScheduler.schedule(delay, () -> EffectUtil.displayParticle(world, particleEffect, alwaysVisible, x, y, z, xOffset, yOffset, zOffset), true);
        }
    }

    private static void displayParticle(Level world, ParticleOptions particleEffect, boolean alwaysVisible, double x, double y, double z, double xOffset, double yOffset, double zOffset) {
        if (world != null) {
            if (alwaysVisible) {
                world.addAlwaysVisibleParticle(particleEffect, x, y, z, xOffset, yOffset, zOffset);
            } else {
                world.addParticle(particleEffect, x, y, z, xOffset, yOffset, zOffset);
            }
        }
    }

    public static Vec3 rotateVector(Vec3 vector, Vec3 axis, double angleDegrees) {
        double angleRadians = Math.toRadians((double)angleDegrees);
        Quaternionf rotation = new Quaternionf(axis.x, axis.y, axis.z, angleRadians);
        Vector3f vec = new Vector3f((float)vector.x, (float)vector.y, (float)vector.z);
        vec.rotate((Quaternionfc)rotation);
        return new Vec3((double)vec.x, (double)vec.y, (double)vec.z);
    }
}

