/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    public static Vec3 findSurface(Level level, Vec3 origin) {
        int x = Mth.floor((double)origin.x);
        int z = Mth.floor((double)origin.z);
        int y = Mth.floor((double)origin.y);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        while (y > level.getMinBuildHeight() && level.getBlockState((BlockPos)mutablePos).isAir()) {
            mutablePos.set(x, --y, z);
        }
        while (y < level.getMaxBuildHeight() && !level.getBlockState(mutablePos.above()).isAir()) {
            mutablePos.set(x, ++y, z);
        }
        return new Vec3((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
    }

    public static List<Entity> getEntitiesInBox(Level world, Entity owner, Vec3 center, Vec3 size) {
        AABB box = new AABB(center.x - size.x / 2.0, center.y - size.y / 2.0, center.z - size.z / 2.0, center.x + size.x / 2.0, center.y + size.y / 2.0, center.z + size.z / 2.0);
        return world.getEntities(owner, box, e -> e != owner && !e.isSpectator());
    }

    public static List<LivingEntity> getLivingEntitiesInBox(Level world, Entity owner, Vec3 center, Vec3 size) {
        AABB box = new AABB(center.x - size.x / 2.0, center.y - size.y / 2.0, center.z - size.z / 2.0, center.x + size.x / 2.0, center.y + size.y / 2.0, center.z + size.z / 2.0);
        return world.getEntitiesOfClass(LivingEntity.class, box, e -> e != owner && !e.isSpectator());
    }

    public static Vec3 getAttackTargetPosition(Player player, double attackRange, double missRange, double offset) {
        double entityHitDist;
        Level world = player.level();
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 forward = Vec3.directionFromRotation((Vec2)player.getRotationVector());
        Vec3 maxReachPos = playerEyePos.add(forward.multiply(attackRange, attackRange, attackRange));
        BlockHitResult blockHit = world.clip(new ClipContext(playerEyePos, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, playerEyePos, maxReachPos, player.level());
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? attackRange + 1.0 : blockHit.getLocation().distanceTo(playerEyePos);
        double hitDistance = Math.min(blockHitDist, entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(playerEyePos) : attackRange + 1.0);
        if (hitDistance > attackRange) {
            hitDistance = missRange;
            return playerEyePos.add(forward.multiply(hitDistance, hitDistance, hitDistance));
        }
        return playerEyePos.add(forward.multiply(hitDistance, hitDistance, hitDistance)).subtract(forward.multiply(offset, offset, offset));
    }

    public static Vec3 raycast(Player player, double maxReachLength) {
        Level world = player.level();
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 forward = Vec3.directionFromRotation((Vec2)player.getRotationVector());
        Vec3 maxReachPos = playerEyePos.add(forward.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(playerEyePos, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, playerEyePos, maxReachPos, player.level());
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(playerEyePos);
        double entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(playerEyePos) : maxReachLength + 1.0;
        double hitDistance = Math.min(blockHitDist, entityHitDist);
        return playerEyePos.add(forward.multiply(hitDistance, hitDistance, hitDistance));
    }

    public static Vec3 raycastBeam(Entity player, double maxReachLength, double radius) {
        return EntityUtil.raycastBeam(player, maxReachLength, radius, Vec3.directionFromRotation((Vec2)player.getRotationVector()));
    }

    public static Vec3 raycastBeam(Entity player, double maxReachLength, double radius, Vec3 directionNormalized) {
        Level world = player.level();
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 maxReachPos = playerEyePos.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(playerEyePos, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult(player, playerEyePos, maxReachPos, player.level());
        entityHit = EntityUtil.getCylinderHit(player, maxReachLength, playerEyePos, radius, entityHit, world, maxReachPos);
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(playerEyePos);
        double entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(playerEyePos) : maxReachLength + 1.0;
        double hitDistance = Math.min(blockHitDist, entityHitDist);
        return playerEyePos.add(directionNormalized.multiply(hitDistance, hitDistance, hitDistance));
    }

    public static BlockHitResult raycastBeamBlockHit(Entity player, double maxReachLength, double radius) {
        return EntityUtil.raycastBeamBlockHit(player, maxReachLength, radius, Vec3.directionFromRotation((Vec2)player.getRotationVector()));
    }

    public static BlockHitResult raycastBeamBlockHit(Entity player, double maxReachLength, double radius, Vec3 directionNormalized) {
        double entityHitDist;
        Level world = player.level();
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 maxReachPos = playerEyePos.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(playerEyePos, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult(player, playerEyePos, maxReachPos, player.level());
        entityHit = EntityUtil.getCylinderHit(player, maxReachLength, playerEyePos, radius, entityHit, world, maxReachPos);
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(playerEyePos);
        double d = entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(playerEyePos) : maxReachLength + 1.0;
        if (blockHitDist < entityHitDist) {
            return blockHit;
        }
        return null;
    }

    public static Vec3 raycast(Player player, double maxReachLength, Vec3 start, Vec3 directionNormalized) {
        Level world = player.level();
        Vec3 maxReachPos = start.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(start, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, start, maxReachPos, player.level());
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(start);
        double entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(start) : maxReachLength + 1.0;
        double hitDistance = Math.min(blockHitDist, entityHitDist);
        return start.add(directionNormalized.multiply(hitDistance, hitDistance, hitDistance));
    }

    public static Vec3 raycastBeam(Player player, double maxReachLength, Vec3 start, Vec3 directionNormalized, double radius) {
        Level world = player.level();
        Vec3 maxReachPos = start.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(start, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, start, maxReachPos, player.level());
        entityHit = EntityUtil.getCylinderHit((Entity)player, maxReachLength, start, radius, entityHit, world, maxReachPos);
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(start);
        double entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(start) : maxReachLength + 1.0;
        double hitDistance = Math.min(blockHitDist, entityHitDist);
        return start.add(directionNormalized.multiply(hitDistance, hitDistance, hitDistance));
    }

    public static Entity raycastEntity(Player player, double maxReachLength) {
        double entityHitDist;
        Level world = player.level();
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 forward = Vec3.directionFromRotation((Vec2)player.getRotationVector());
        Vec3 maxReachPos = playerEyePos.add(forward.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(playerEyePos, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, playerEyePos, maxReachPos, player.level());
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(playerEyePos);
        double d = entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(playerEyePos) : maxReachLength + 1.0;
        if (blockHitDist > entityHitDist) {
            return entityHit.getEntity();
        }
        return null;
    }

    public static Entity raycastBeamEntity(Entity player, double maxReachLength, double radius) {
        return EntityUtil.raycastBeamEntity(player, maxReachLength, radius, Vec3.directionFromRotation((Vec2)player.getRotationVector()));
    }

    public static Entity raycastBeamEntity(Entity player, double maxReachLength, double radius, Vec3 directionNormalized) {
        double entityHitDist;
        Level world = player.level();
        Vec3 playerEyePos = player.getEyePosition();
        Vec3 maxReachPos = playerEyePos.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(playerEyePos, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult(player, playerEyePos, maxReachPos, player.level());
        entityHit = EntityUtil.getCylinderHit(player, maxReachLength, playerEyePos, radius, entityHit, world, maxReachPos);
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(playerEyePos);
        double d = entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(playerEyePos) : maxReachLength + 1.0;
        if (blockHitDist > entityHitDist) {
            return entityHit.getEntity();
        }
        return null;
    }

    public static Entity raycastEntity(Player player, double maxReachLength, Vec3 start, Vec3 directionNormalized) {
        double entityHitDist;
        Level world = player.level();
        Vec3 maxReachPos = start.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(start, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, start, maxReachPos, player.level());
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(start);
        double d = entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(start) : maxReachLength + 1.0;
        if (blockHitDist > entityHitDist) {
            return entityHit.getEntity();
        }
        return null;
    }

    public static Entity raycastBeamEntity(Player player, double maxReachLength, Vec3 start, Vec3 directionNormalized, double radius) {
        double entityHitDist;
        Level world = player.level();
        Vec3 maxReachPos = start.add(directionNormalized.scale(maxReachLength));
        BlockHitResult blockHit = world.clip(new ClipContext(start, maxReachPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHit = EntityUtil.getEntityHitResult((Entity)player, start, maxReachPos, player.level());
        entityHit = EntityUtil.getCylinderHit((Entity)player, maxReachLength, start, radius, entityHit, world, maxReachPos);
        double blockHitDist = blockHit.getType() == HitResult.Type.MISS ? maxReachLength + 1.0 : blockHit.getLocation().distanceTo(start);
        double d = entityHitDist = entityHit != null ? entityHit.getLocation().distanceTo(start) : maxReachLength + 1.0;
        if (blockHitDist > entityHitDist) {
            return entityHit.getEntity();
        }
        return null;
    }

    @Nullable
    private static EntityHitResult getCylinderHit(Entity player, double maxReachLength, Vec3 start, double radius, EntityHitResult entityHit, Level world, Vec3 maxReachPos) {
        if (entityHit == null) {
            for (Entity entity : world.getEntities(player, new AABB(start, maxReachPos).inflate(radius))) {
                if (!entity.isAttackable()) continue;
                Vec3 closestPoint = EntityUtil.getClosestPointOnLine(entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0), start, maxReachPos);
                double scaledRadius = radius + 1.0;
                Vec3 scaledDistance = closestPoint.subtract(entity.position().add(0.0, (double)entity.getBbHeight() * 0.5, 0.0)).multiply((double)(1.0f / entity.getBbWidth()), (double)(1.0f / entity.getBbHeight()), (double)(1.0f / entity.getBbWidth()));
                if (!(scaledDistance.length() <= scaledRadius)) continue;
                double d = closestPoint.distanceTo(start);
                double d2 = entityHit != null ? entityHit.getLocation().distanceTo(start) : maxReachLength;
                if (!(d < d2)) continue;
                entityHit = new EntityHitResult(entity, new Vec3(entity.getX(), entity.getY(0.5), entity.getZ()));
            }
        }
        return entityHit;
    }

    public static EntityHitResult getEntityHitResult(Entity player, Vec3 startLoc, Vec3 endLoc, Level level) {
        double distance = startLoc.distanceTo(endLoc);
        AABB searchBox = new AABB(startLoc, endLoc).inflate(1.0);
        List entities = level.getEntities(player, searchBox, entity -> entity.isAttackable() && entity.getBoundingBox().clip(startLoc, endLoc).isPresent());
        EntityHitResult closestHit = null;
        double closestDistance = distance;
        for (Entity entity2 : entities) {
            double hitDistance;
            AABB boundingBox = entity2.getBoundingBox();
            Optional hit = boundingBox.clip(startLoc, endLoc);
            if (!hit.isPresent() || !((hitDistance = startLoc.distanceTo((Vec3)hit.get())) < closestDistance)) continue;
            closestDistance = hitDistance;
            closestHit = new EntityHitResult(entity2, (Vec3)hit.get());
        }
        return closestHit;
    }

    public static Vec3 getClosestPointOnLine(Vec3 point, Vec3 a, Vec3 b) {
        Vec3 ab = b.subtract(a);
        double t = point.subtract(a).dot(ab) / ab.lengthSqr();
        t = Math.max(0.0, Math.min(1.0, t));
        return a.add(ab.scale(t));
    }
}

