/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.function.BiFunction;
import net.stln.magitech.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class TableHelper {
    @NotNull
    public static <R, C, V> V getOrDefault(@NotNull Table<R, C, V> table, @NotNull R row, @NotNull C column, @NotNull V defaultValue) {
        Object value = table.get(row, column);
        return (V)(value == null ? defaultValue : value);
    }

    @NotNull
    public static <R, C, V> V getOrDefault(@NotNull Table<R, C, V> table, @NotNull R row, @NotNull C column, @NotNull BiFunction<R, C, V> function) {
        Object value = table.get(row, column);
        return (V)(value == null ? function.apply(row, column) : value);
    }

    @NotNull
    public static <R, C, V> V computeIfAbsent(@NotNull Table<R, C, V> table, @NotNull R row, @NotNull C column, @NotNull BiFunction<R, C, V> function) {
        Object value = table.get(row, column);
        if (value == null) {
            value = function.apply(row, column);
            table.put(row, column, value);
        }
        return (V)value;
    }

    public static <R, C, V> void removeByRow(@NotNull Table<R, C, V> table, @NotNull R row) {
        HashSet columnSet = new HashSet(table.columnKeySet());
        for (Object column : columnSet) {
            table.remove(row, column);
        }
    }

    public static <R, C, V> void forEach(@NotNull Table<R, C, V> table, TriConsumer<R, C, V> consumer) {
        for (Table.Cell cell : table.cellSet()) {
            consumer.accept(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }
}

