/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.worldgen;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OreSurfaceFeature
extends Feature<NoneFeatureConfiguration> {
    private final BlockState blockToPlace;
    private final List<Block> blockToPlaced;
    private final double propability;

    public OreSurfaceFeature(BlockState blockToPlace, List<Block> blockToPlaced, double propability) {
        super(NoneFeatureConfiguration.CODEC);
        this.blockToPlace = blockToPlace;
        this.blockToPlaced = blockToPlaced;
        this.propability = propability;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        ChunkPos chunkPos = new ChunkPos(context.origin());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                for (int dy = level.getMinBuildHeight(); dy < level.getMaxBuildHeight(); ++dy) {
                    pos.set(chunkPos.getMinBlockX() + dx, dy, chunkPos.getMinBlockZ() + dz);
                    BlockState state = level.getBlockState((BlockPos)pos);
                    boolean isTargetBlock = false;
                    for (Block block : this.blockToPlaced) {
                        if (!state.is(block)) continue;
                        isTargetBlock = true;
                    }
                    if (!isTargetBlock) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos facePos = pos.relative(dir);
                        if (!level.getBlockState(facePos).isAir() && !level.getBlockState(facePos).is(Blocks.WATER) || !((double)level.getRandom().nextFloat() < this.propability)) continue;
                        BlockState blockState = this.blockToPlace;
                        if (this.blockToPlace.hasProperty((Property)BlockStateProperties.FACING)) {
                            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)dir);
                        }
                        if (level.getBlockState(facePos).is(Blocks.WATER) && this.blockToPlace.hasProperty((Property)BlockStateProperties.FACING)) {
                            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                        }
                        level.setBlock(facePos, blockState, 2);
                    }
                }
            }
        }
        return true;
    }
}

