/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.worldgen.terrain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.stln.magitech.block.BlockInit;

public class ScorchedLavaLakeFeature
extends Feature<NoneFeatureConfiguration> {
    public ScorchedLavaLakeFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    private static boolean isExposed(WorldGenLevel level, Set<BlockPos> positions, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        return ScorchedLavaLakeFeature.isExposedDirection(level, pos, mutablePos, Direction.NORTH) || ScorchedLavaLakeFeature.isExposedDirection(level, pos, mutablePos, Direction.EAST) || ScorchedLavaLakeFeature.isExposedDirection(level, pos, mutablePos, Direction.SOUTH) || ScorchedLavaLakeFeature.isExposedDirection(level, pos, mutablePos, Direction.WEST) || ScorchedLavaLakeFeature.isExposedDirection(level, pos, mutablePos, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel level, BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction direction) {
        mutablePos.setWithOffset((Vec3i)pos, direction);
        return !level.getBlockState((BlockPos)mutablePos).isFaceSturdy((BlockGetter)level, (BlockPos)mutablePos, direction.getOpposite());
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int j;
        int i;
        Predicate<BlockState> predicate;
        BlockPos blockpos;
        RandomSource randomsource;
        NoneFeatureConfiguration none;
        WorldGenLevel worldgenlevel = context.level();
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, none = (NoneFeatureConfiguration)context.config(), randomsource = context.random(), blockpos = context.origin(), predicate = p_204782_ -> p_204782_.is((Block)BlockInit.SCORCHED_GRASS_SOIL.get()) || p_204782_.is((Block)BlockInit.SCORCHED_SOIL.get()) || p_204782_.is(Blocks.STONE), i = randomsource.nextInt(4, 7) + 1, j = randomsource.nextInt(4, 7) + 1);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel level, NoneFeatureConfiguration config, RandomSource random, BlockPos pos, Predicate<BlockState> state, int xRadius, int zRadius) {
        Set<BlockPos> set = this.placeGroundPatch1(level, config, random, pos, state, xRadius, zRadius);
        HashSet<BlockPos> set1 = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : set) {
            if (ScorchedLavaLakeFeature.isExposed(level, set, blockpos, blockpos$mutableblockpos)) continue;
            set1.add(blockpos);
        }
        for (BlockPos blockpos1 : set1) {
            level.setBlock(blockpos1, Blocks.LAVA.defaultBlockState(), 2);
            Predicate<BlockState> predicate = p_204782_ -> p_204782_.is((Block)BlockInit.SCORCHED_GRASS_SOIL.get()) || p_204782_.is((Block)BlockInit.SCORCHED_SOIL.get()) || p_204782_.is(Blocks.STONE);
            ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
            directions.remove(Direction.UP);
            for (Direction direction : directions) {
                BlockPos pos1 = blockpos1.relative(direction);
                BlockState blockState = level.getBlockState(pos1);
                if (!predicate.test(blockState)) continue;
                level.setBlock(pos1, Blocks.SMOOTH_BASALT.defaultBlockState(), 2);
            }
        }
        return set1;
    }

    protected Set<BlockPos> placeGroundPatch1(WorldGenLevel level, NoneFeatureConfiguration config, RandomSource random, BlockPos pos, Predicate<BlockState> state, int xRadius, int zRadius) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = blockpos$mutableblockpos.mutable();
        Direction direction = Direction.DOWN;
        Direction direction1 = direction.getOpposite();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -xRadius; i <= xRadius; ++i) {
            boolean flag = i == -xRadius || i == xRadius;
            for (int j = -zRadius; j <= zRadius; ++j) {
                float f2;
                boolean flag1 = j == -zRadius || j == zRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean flag4 = flag2 && !flag3;
                double rot = Math.toRadians(random.nextInt(360));
                float f1 = Mth.abs((float)((float)(Math.cos(rot) * (double)i - Math.sin(rot) * (double)j))) - 0.25f;
                float dist = f1 * f1 / (float)(xRadius * xRadius) + (f2 = Mth.abs((float)((float)(Math.sin(rot) * (double)i + Math.cos(rot) * (double)j))) - 0.25f) * f2 / (float)(zRadius * zRadius);
                if (!((double)dist <= 0.9) || flag3 || flag4 && random.nextFloat() > 0.7f) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, i, 0, j);
                for (int k = 0; level.isStateAtPosition((BlockPos)blockpos$mutableblockpos, BlockBehaviour.BlockStateBase::isAir) && k < 5; ++k) {
                    blockpos$mutableblockpos.move(direction);
                }
                for (int i1 = 0; level.isStateAtPosition((BlockPos)blockpos$mutableblockpos, p_284926_ -> !p_284926_.isAir()) && i1 < 5; ++i1) {
                    blockpos$mutableblockpos.move(direction1);
                }
                blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos$mutableblockpos, Direction.DOWN);
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos1);
                if (!level.isEmptyBlock((BlockPos)blockpos$mutableblockpos) || !blockstate.isFaceSturdy((BlockGetter)level, (BlockPos)blockpos$mutableblockpos1, Direction.DOWN.getOpposite())) continue;
                int l = 3 + (random.nextFloat() < 0.8f ? 1 : 0);
                BlockPos blockpos = blockpos$mutableblockpos1.immutable();
                boolean flag5 = this.placeGround(level, config, state, random, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
        return set;
    }

    protected boolean placeGround(WorldGenLevel level, NoneFeatureConfiguration config, Predicate<BlockState> replaceableblocks, RandomSource random, BlockPos.MutableBlockPos mutablePos, int maxDistance) {
        for (int i = 0; i < maxDistance; ++i) {
            BlockState blockstate1;
            BlockState blockstate = Blocks.SMOOTH_BASALT.defaultBlockState();
            if (blockstate.is((blockstate1 = level.getBlockState((BlockPos)mutablePos)).getBlock())) continue;
            if (!replaceableblocks.test(blockstate1)) {
                return i != 0;
            }
            level.setBlock((BlockPos)mutablePos, blockstate, 2);
            mutablePos.move(Direction.DOWN);
        }
        return true;
    }
}

