/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.stln.magitech.worldgen.tree.TreeGrowerInit;

public class RandomBranchingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<RandomBranchingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(p_70261_ -> RandomBranchingTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)p_70261_).apply((Applicative)p_70261_, RandomBranchingTrunkPlacer::new));
    private final int branchLength;

    public RandomBranchingTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
        this.branchLength = baseHeight / 3;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TreeGrowerInit.RANDOM_BRANCHING_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> foliage = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos.MutableBlockPos pos = startPos.mutable();
        Direction[] directions = (Direction[])Direction.Plane.HORIZONTAL.stream().toArray(Direction[]::new);
        int mid = height / 3;
        Direction prevBranchDir = null;
        int baseBranchLength = 3;
        for (int y = 0; y < height; ++y) {
            this.placeLog(reader, replacer, random, (BlockPos)pos, config);
            if (y >= mid && (y - mid) % 2 == 0 && y < height - 1) {
                Direction branchDir = directions[random.nextInt(directions.length)];
                if (branchDir == prevBranchDir) {
                    branchDir = branchDir.getClockWise();
                }
                int length = baseBranchLength + random.nextInt(this.branchLength);
                --baseBranchLength;
                BlockPos branchStart = pos.immutable();
                BlockPos.MutableBlockPos branchPos = branchStart.mutable();
                for (int i = 0; i < length; ++i) {
                    branchPos.move(branchDir);
                    this.placeLog(reader, replacer, random, (BlockPos)branchPos, config, branchDir.getAxis());
                    if (!random.nextBoolean() || i <= 0) continue;
                    branchPos.move(Direction.UP);
                }
                foliage.add(new FoliagePlacer.FoliageAttachment(branchPos.immutable(), 0, false));
                prevBranchDir = branchDir;
                if (random.nextBoolean()) {
                    pos.move(branchDir.getOpposite());
                }
            }
            pos.move(Direction.UP);
        }
        foliage.add(new FoliagePlacer.FoliageAttachment(pos.immutable(), 0, false));
        return foliage;
    }

    private void placeLog(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, BlockPos pos, TreeConfiguration config, Direction.Axis axisDir) {
        BlockState log = (BlockState)config.trunkProvider.getState(random, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axisDir);
        replacer.accept(pos, log);
    }

    protected boolean placeLog(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, BlockPos pos, TreeConfiguration config) {
        this.placeLog(reader, replacer, random, pos, config, Direction.Axis.Y);
        return false;
    }
}

