/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.data;

import com.google.common.collect.Maps;
import com.pla.pladailyboss.enums.KeyEntityState;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class KeyEntityManager
extends SavedData {
    private final Map<UUID, KeyEntityData> dataMap = Maps.newHashMap();
    public static final String DATA_NAME = "pla_key_entity_manager";

    public static KeyEntityManager get(ServerLevel level) {
        return (KeyEntityManager)level.m_8895_().m_164861_(KeyEntityManager::load, KeyEntityManager::new, DATA_NAME);
    }

    public void update(UUID keyEntityUUID, UUID mobUUID, KeyEntityState state, long updatedTime, String summonedMobRL) {
        this.dataMap.put(keyEntityUUID, new KeyEntityData(mobUUID, state, updatedTime, summonedMobRL));
        this.m_77762_();
    }

    public KeyEntityData get(UUID keyEntityUUID) {
        return this.dataMap.get(keyEntityUUID);
    }

    public void remove(UUID keyEntityUUID) {
        this.dataMap.remove(keyEntityUUID);
        this.m_77762_();
    }

    public static KeyEntityManager load(CompoundTag tag) {
        KeyEntityManager manager = new KeyEntityManager();
        ListTag list = tag.m_128437_("KeyEntities", 10);
        for (Tag t : list) {
            CompoundTag entry = (CompoundTag)t;
            UUID keyUUID = entry.m_128342_("KeyUUID");
            UUID mobUUID = entry.m_128441_("MobUUID") ? entry.m_128342_("MobUUID") : null;
            KeyEntityState state = KeyEntityState.valueOf(entry.m_128461_("State"));
            long time = entry.m_128454_("UpdatedTime");
            String summonedMobRL = entry.m_128461_("SummonedMobRL");
            manager.dataMap.put(keyUUID, new KeyEntityData(mobUUID, state, time, summonedMobRL));
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, KeyEntityData> entry : this.dataMap.entrySet()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("KeyUUID", entry.getKey());
            if (entry.getValue().mobUUID() != null) {
                nbt.m_128362_("MobUUID", entry.getValue().mobUUID());
            }
            nbt.m_128359_("State", entry.getValue().state().name());
            nbt.m_128356_("UpdatedTime", entry.getValue().updatedTime());
            nbt.m_128359_("SummonedMobRL", entry.getValue().summonedMobRL());
            list.add((Object)nbt);
        }
        tag.m_128365_("KeyEntities", (Tag)list);
        return tag;
    }

    public record KeyEntityData(UUID mobUUID, KeyEntityState state, long updatedTime, String summonedMobRL) {
    }
}

